/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.Configurable;
import VASSAL.build.widget.PieceSlot;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceDefiner;
import VASSAL.counters.PieceEditor;
import java.util.Enumeration;
import java.util.Vector;

public class MassPieceDefiner
extends PieceDefiner {
    private Vector definers = new Vector();

    public MassPieceDefiner(Configurable configurable) {
        this.init(configurable);
        if (this.definers.size() > 0) {
            this.setPiece(((Entry)this.definers.firstElement()).slot.getPiece());
            Vector vector = this.getTemplate();
            for (int i = 0; i < this.definers.size(); ++i) {
                GamePiece gamePiece = ((Entry)this.definers.elementAt(i)).definer.getPiece();
                if (this.matchesTemplate(gamePiece, vector)) continue;
                this.definers.removeElementAt(i--);
            }
        }
    }

    private void init(Configurable configurable) {
        Object object;
        if (configurable instanceof PieceSlot) {
            object = new Def();
            ((PieceDefiner)object).setPiece(((PieceSlot)configurable).getPiece());
            this.definers.addElement(new Entry((PieceSlot)configurable, (PieceDefiner)object));
        }
        object = configurable.getConfigureComponents();
        for (int i = 0; i < ((Configurable[])object).length; ++i) {
            this.init((Configurable)object[i]);
        }
    }

    private Vector getTemplate() {
        GamePiece gamePiece = ((Entry)this.definers.firstElement()).definer.getPiece();
        Vector vector = new Vector();
        while (gamePiece instanceof Decorator) {
            vector.addElement(gamePiece.getClass());
            gamePiece = ((Decorator)gamePiece).piece;
        }
        vector.addElement(gamePiece.getClass());
        return vector;
    }

    private boolean matchesTemplate(GamePiece gamePiece, Vector vector) {
        Enumeration enumeration = vector.elements();
        while (gamePiece instanceof Decorator && enumeration.hasMoreElements()) {
            if (gamePiece.getClass() != enumeration.nextElement()) {
                return false;
            }
            gamePiece = ((Decorator)gamePiece).piece;
        }
        return enumeration.hasMoreElements() ? gamePiece.getClass() == enumeration.nextElement() && !enumeration.hasMoreElements() : false;
    }

    protected void addTrait(Decorator decorator) {
        super.addTrait(decorator);
        Enumeration enumeration = this.definers.elements();
        while (enumeration.hasMoreElements()) {
            ((Entry)enumeration.nextElement()).definer.addTrait(decorator);
        }
    }

    protected void removeTrait(int n) {
        super.removeTrait(n);
        Enumeration enumeration = this.definers.elements();
        while (enumeration.hasMoreElements()) {
            ((Entry)enumeration.nextElement()).definer.removeTrait(n);
        }
    }

    protected void moveDecoratorUp(int n) {
        super.moveDecoratorUp(n);
        Enumeration enumeration = this.definers.elements();
        while (enumeration.hasMoreElements()) {
            ((Entry)enumeration.nextElement()).definer.moveDecoratorUp(n);
        }
    }

    protected void moveDecoratorDown(int n) {
        super.moveDecoratorDown(n);
        Enumeration enumeration = this.definers.elements();
        while (enumeration.hasMoreElements()) {
            ((Entry)enumeration.nextElement()).definer.moveDecoratorDown(n);
        }
    }

    protected boolean edit(int n) {
        boolean bl = super.edit(n);
        Enumeration enumeration = this.definers.elements();
        while (enumeration.hasMoreElements()) {
            ((Entry)enumeration.nextElement()).definer.edit(n);
        }
        return bl;
    }

    public void save() {
        Enumeration enumeration = this.definers.elements();
        while (enumeration.hasMoreElements()) {
            Entry entry = (Entry)enumeration.nextElement();
            entry.slot.setPiece(entry.definer.getPiece());
        }
    }

    private class Def
    extends PieceDefiner {
        private Def() {
        }

        protected boolean edit(int n) {
            Object e = MassPieceDefiner.this.inUseModel.elementAt(n);
            if (!(e instanceof EditablePiece)) {
                return false;
            }
            PieceEditor pieceEditor = ((EditablePiece)e).getEditor();
            EditablePiece editablePiece = (EditablePiece)this.inUseModel.elementAt(n);
            editablePiece.mySetType(pieceEditor.getType());
            if (editablePiece instanceof Decorator) {
                ((Decorator)((Object)editablePiece)).mySetState(pieceEditor.getState());
            } else {
                editablePiece.setState(pieceEditor.getState());
            }
            return true;
        }
    }

    private static class Entry {
        private PieceSlot slot;
        private PieceDefiner definer;

        private Entry(PieceSlot pieceSlot, PieceDefiner pieceDefiner) {
            this.slot = pieceSlot;
            this.definer = pieceDefiner;
        }
    }
}

