/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.counters.ImagePicker;
import VASSAL.tools.ScrollPane;
import java.awt.CardLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MultiImagePicker
extends JPanel {
    private JList imageList;
    private DefaultListModel imageListElements = new DefaultListModel();
    private CardLayout cl = new CardLayout();
    private JPanel multiPanel = new JPanel();

    public MultiImagePicker() {
        this.setLayout(new BoxLayout(this, 0));
        this.imageList = new JList(this.imageListElements);
        this.imageList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                MultiImagePicker.this.showSelected();
            }
        });
        this.imageList.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    MultiImagePicker.this.showSelected();
                }
            }
        });
        this.imageList.setVisibleRowCount(4);
        this.imageList.setPrototypeCellValue("Image 999");
        this.imageList.setMinimumSize(this.imageList.getPreferredSize());
        this.multiPanel.setLayout(this.cl);
        this.add(this.multiPanel);
        ScrollPane scrollPane = new ScrollPane(this.imageList);
        scrollPane.getViewport().setMinimumSize(this.imageList.getPreferredSize());
        this.add(scrollPane);
        this.addEntry();
    }

    public void showSelected() {
        if (this.imageList.getSelectedValue() != null) {
            this.cl.show(this.multiPanel, (String)this.imageList.getSelectedValue());
        }
    }

    public void addEntry() {
        String string = "Image " + (this.imageListElements.size() + 1);
        this.imageListElements.addElement(string);
        ImagePicker imagePicker = new ImagePicker();
        this.multiPanel.add(string, imagePicker);
        this.imageList.setSelectedIndex(this.imageListElements.size() - 1);
        this.cl.show(this.multiPanel, (String)this.imageList.getSelectedValue());
    }

    public JList getList() {
        return this.imageList;
    }

    public Enumeration getImageNames() {
        Vector<String> vector = new Vector<String>();
        int n = this.imageListElements.size();
        for (int i = 0; i < n; ++i) {
            vector.addElement(((ImagePicker)this.multiPanel.getComponent(i)).getImageName());
        }
        return vector.elements();
    }

    public void removeEntryAt(int n) {
        if (n < 0 || n >= this.imageListElements.size()) {
            return;
        }
        this.multiPanel.remove(n);
        this.imageListElements.removeElementAt(n);
        if (n < this.imageListElements.size()) {
            this.imageList.setSelectedIndex(n);
        } else if (n > 0) {
            this.imageList.setSelectedIndex(n - 1);
        }
        if (this.imageList.getSelectedValue() != null) {
            this.cl.show(this.multiPanel, (String)this.imageList.getSelectedValue());
        }
    }

    public void clear() {
        for (int i = 0; i < this.imageListElements.size(); ++i) {
            ((ImagePicker)this.multiPanel.getComponent(i)).setImageName(null);
        }
        this.multiPanel.removeAll();
        this.imageListElements.removeAllElements();
    }

    public void setImageList(String[] stringArray) {
        while (stringArray.length > this.multiPanel.getComponentCount()) {
            this.addEntry();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            ((ImagePicker)this.multiPanel.getComponent(i)).setImageName(stringArray[i]);
        }
    }
}

