/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.ObscurableOptions;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.PieceAccessConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.ImagePicker;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceAccess;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.PlayerAccess;
import VASSAL.tools.SequenceEncoder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.Area;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class Obscurable
extends Decorator
implements EditablePiece {
    public static final String ID = "obs;";
    protected static final char INSET = 'I';
    protected static final char BACKGROUND = 'B';
    protected static final char PEEK = 'P';
    protected static final char IMAGE = 'G';
    protected char obscureKey;
    protected KeyStroke keyCommand;
    protected KeyStroke peekKey;
    protected String imageName;
    protected String obscuredToOthersImage;
    protected String obscuredBy;
    protected String hideCommand = "Mask";
    protected GamePiece obscuredToMeView;
    protected GamePiece obscuredToOthersView;
    protected boolean peeking;
    protected char displayStyle = (char)73;
    protected String maskName = "?";
    protected PieceAccess access = PlayerAccess.getInstance();
    protected KeyCommand[] commandsWithPeek;
    protected KeyCommand[] commandsWithoutPeek;
    protected KeyCommand hide;
    protected KeyCommand peek;
    static /* synthetic */ Class class$java$awt$Window;

    public Obscurable() {
        this("obs;M;", null);
    }

    public Obscurable(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    public void mySetState(String string) {
        this.obscuredBy = "null".equals(string) ? null : string;
    }

    public void mySetType(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        decoder.nextToken();
        this.keyCommand = decoder.nextKeyStroke(null);
        this.imageName = decoder.nextToken();
        this.obscuredToMeView = GameModule.getGameModule().createPiece("piece;;;" + this.imageName + ";;");
        this.hideCommand = decoder.nextToken(this.hideCommand);
        if (decoder.hasMoreTokens()) {
            String string2 = decoder.nextToken(String.valueOf('I'));
            this.displayStyle = string2.charAt(0);
            switch (this.displayStyle) {
                case 'P': {
                    if (string2.length() > 1) {
                        this.peekKey = string2.length() == 2 ? KeyStroke.getKeyStroke((int)string2.charAt(1), 2) : HotKeyConfigurer.decode(string2.substring(1));
                        this.peeking = false;
                        break;
                    }
                    this.peekKey = null;
                    this.peeking = true;
                    break;
                }
                case 'G': {
                    if (string2.length() <= 1) break;
                    this.obscuredToOthersImage = string2.substring(1);
                    this.obscuredToOthersView = GameModule.getGameModule().createPiece("piece;;;" + this.obscuredToOthersImage + ";;");
                    this.obscuredToMeView.setPosition(new Point());
                }
            }
        }
        this.maskName = decoder.nextToken(this.maskName);
        this.access = PieceAccessConfigurer.decode(decoder.nextToken(null));
        this.commandsWithPeek = null;
        this.hide = null;
        this.peek = null;
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.keyCommand).append(this.imageName).append(this.hideCommand);
        switch (this.displayStyle) {
            case 'P': {
                if (this.peekKey == null) {
                    sequenceEncoder.append(this.displayStyle);
                    break;
                }
                sequenceEncoder.append(this.displayStyle + HotKeyConfigurer.encode(this.peekKey));
                break;
            }
            case 'G': {
                sequenceEncoder.append(this.displayStyle + this.obscuredToOthersImage);
                break;
            }
            default: {
                sequenceEncoder.append(this.displayStyle);
            }
        }
        sequenceEncoder.append(this.maskName);
        sequenceEncoder.append(PieceAccessConfigurer.encode(this.access));
        return ID + sequenceEncoder.getValue();
    }

    public String myGetState() {
        return this.obscuredBy == null ? "null" : this.obscuredBy;
    }

    public Rectangle boundingBox() {
        if (this.obscuredToMe()) {
            return this.bBoxObscuredToMe();
        }
        if (this.obscuredToOthers()) {
            return this.bBoxObscuredToOthers();
        }
        return this.piece.boundingBox();
    }

    public Shape getShape() {
        if (this.obscuredToMe()) {
            return this.obscuredToMeView.getShape();
        }
        if (this.obscuredToOthers()) {
            switch (this.displayStyle) {
                case 'B': {
                    return this.obscuredToMeView.getShape();
                }
                case 'I': {
                    return this.piece.getShape();
                }
                case 'P': {
                    if (this.peeking && Boolean.TRUE.equals(this.getProperty("Selected"))) {
                        return this.piece.getShape();
                    }
                    return this.obscuredToMeView.getShape();
                }
                case 'G': {
                    Area area = new Area(this.obscuredToOthersView.getShape());
                    area.add(new Area(this.piece.getShape()));
                    return area;
                }
            }
            return this.piece.getShape();
        }
        return this.piece.getShape();
    }

    public boolean obscuredToMe() {
        return !this.access.currentPlayerHasAccess(this.obscuredBy);
    }

    public boolean obscuredToOthers() {
        return this.obscuredBy != null;
    }

    public void setProperty(Object object, Object object2) {
        if (ID.equals(object)) {
            if (object2 instanceof String || object2 == null) {
                this.obscuredBy = (String)object2;
                if ("null".equals(this.obscuredBy)) {
                    this.obscuredBy = null;
                }
            }
        } else if ("Selected".equals(object)) {
            if (!Boolean.TRUE.equals(object2) && this.peekKey != null) {
                this.peeking = false;
            }
            super.setProperty(object, object2);
        } else {
            super.setProperty(object, object2);
        }
    }

    public Object getProperty(Object object) {
        if ("Obscured".equals(object)) {
            return new Boolean(this.obscuredToMe());
        }
        if ("ObscuredToOthers".equals(object)) {
            return new Boolean(this.obscuredToOthers());
        }
        if (ID.equals(object)) {
            return this.obscuredBy;
        }
        if ("visibleState".equals(object)) {
            return this.myGetState() + this.isPeeking() + this.piece.getProperty(object);
        }
        return super.getProperty(object);
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        if (this.obscuredToMe()) {
            this.drawObscuredToMe(graphics, n, n2, component, d);
        } else if (this.obscuredToOthers()) {
            this.drawObscuredToOthers(graphics, n, n2, component, d);
        } else {
            this.piece.draw(graphics, n, n2, component, d);
        }
    }

    protected void drawObscuredToMe(Graphics graphics, int n, int n2, Component component, double d) {
        this.obscuredToMeView.draw(graphics, n, n2, component, d);
    }

    protected void drawObscuredToOthers(Graphics graphics, int n, int n2, Component component, double d) {
        switch (this.displayStyle) {
            case 'B': {
                this.obscuredToMeView.draw(graphics, n, n2, component, d);
                this.piece.draw(graphics, n, n2, component, d * 0.5);
                break;
            }
            case 'I': {
                this.piece.draw(graphics, n, n2, component, d);
                Rectangle rectangle = this.piece.getShape().getBounds();
                Rectangle rectangle2 = this.obscuredToMeView.getShape().getBounds();
                this.obscuredToMeView.draw(graphics, n - (int)(d * (double)rectangle.width / 2.0 - 0.5 * d * (double)rectangle2.width / 2.0), n2 - (int)(d * (double)rectangle.height / 2.0 - 0.5 * d * (double)rectangle2.height / 2.0), component, d * 0.5);
                break;
            }
            case 'P': {
                if (this.peeking && Boolean.TRUE.equals(this.getProperty("Selected"))) {
                    this.piece.draw(graphics, n, n2, component, d);
                    break;
                }
                this.obscuredToMeView.draw(graphics, n, n2, component, d);
                break;
            }
            case 'G': {
                this.piece.draw(graphics, n, n2, component, d);
                this.obscuredToOthersView.draw(graphics, n, n2, component, d);
            }
        }
    }

    public boolean isPeeking() {
        return this.peeking;
    }

    protected Rectangle bBoxObscuredToMe() {
        return this.obscuredToMeView.boundingBox();
    }

    protected Rectangle bBoxObscuredToOthers() {
        switch (this.displayStyle) {
            case 'B': {
                return this.bBoxObscuredToMe();
            }
            case 'G': {
                return this.piece.boundingBox().union(this.obscuredToOthersView.boundingBox());
            }
        }
        return this.piece.boundingBox();
    }

    public String getName() {
        String string;
        String string2 = string = this.maskName == null ? "?" : this.maskName;
        if (this.obscuredToMe()) {
            return string;
        }
        if (this.obscuredToOthers()) {
            return this.piece.getName() + "(" + string + ")";
        }
        return this.piece.getName();
    }

    public KeyCommand[] getKeyCommands() {
        if (this.obscuredToMe()) {
            KeyCommand[] keyCommandArray = this.myGetKeyCommands();
            KeyCommand[] keyCommandArray2 = (KeyCommand[])Decorator.getInnermost(this).getProperty("KeyCommands");
            if (keyCommandArray2 == null) {
                return keyCommandArray;
            }
            KeyCommand[] keyCommandArray3 = new KeyCommand[keyCommandArray2.length + keyCommandArray.length];
            System.arraycopy(keyCommandArray, 0, keyCommandArray3, 0, keyCommandArray.length);
            System.arraycopy(keyCommandArray2, 0, keyCommandArray3, keyCommandArray.length, keyCommandArray2.length);
            return keyCommandArray3;
        }
        return super.getKeyCommands();
    }

    public KeyCommand[] myGetKeyCommands() {
        ArrayList<KeyCommand> arrayList = new ArrayList<KeyCommand>();
        GamePiece gamePiece = Decorator.getOutermost(this);
        if (this.keyCommand == null) {
            this.keyCommand = KeyStroke.getKeyStroke((int)this.obscureKey, 2);
        }
        this.hide = new KeyCommand(this.hideCommand, this.keyCommand, gamePiece);
        if (this.hideCommand.length() > 0 && this.isMaskable()) {
            arrayList.add(this.hide);
            this.commandsWithoutPeek = new KeyCommand[]{this.hide};
        } else {
            this.commandsWithoutPeek = new KeyCommand[0];
        }
        this.peek = new KeyCommand("Peek", this.peekKey, gamePiece);
        if (this.displayStyle == 'P' && this.peekKey != null) {
            arrayList.add(this.peek);
        }
        this.commandsWithPeek = arrayList.toArray(new KeyCommand[arrayList.size()]);
        if (this.obscuredToOthers() && this.isMaskable() && this.displayStyle == 'P' && this.peekKey != null) {
            return this.commandsWithPeek;
        }
        return this.commandsWithoutPeek;
    }

    public boolean isMaskableBy(String string) {
        return this.isMaskable();
    }

    public boolean isMaskable() {
        return this.access.currentPlayerCanModify(this.obscuredBy) || ObscurableOptions.getInstance().isUnmaskable(this.obscuredBy);
    }

    public Command keyEvent(KeyStroke keyStroke) {
        if (!this.obscuredToMe()) {
            return super.keyEvent(keyStroke);
        }
        return this.myKeyEvent(keyStroke);
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        Object object;
        Command command = null;
        this.myGetKeyCommands();
        if (this.hide.matches(keyStroke)) {
            object = new ChangeTracker(this);
            if (this.obscuredToOthers() || this.obscuredToMe()) {
                this.obscuredBy = null;
            } else if (!this.obscuredToMe()) {
                this.obscuredBy = this.access.getCurrentPlayerId();
            }
            command = ((ChangeTracker)object).getChangeCommand();
        } else if (this.peek.matches(keyStroke) && this.obscuredToOthers() && Boolean.TRUE.equals(this.getProperty("Selected"))) {
            this.peeking = true;
        }
        if (command != null && 'P' == this.displayStyle && this.peekKey == null && this.obscuredToOthers()) {
            object = new Runnable(){

                public void run() {
                    KeyBuffer.getBuffer().remove(Decorator.getOutermost(Obscurable.this));
                }
            };
            SwingUtilities.invokeLater((Runnable)object);
        }
        return command;
    }

    public String getDescription() {
        return "Mask";
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Mask.htm");
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    public static void setAllHidden(boolean bl) {
        if (bl) {
            PieceAccess.GlobalAccess.hideAll();
        } else {
            PieceAccess.GlobalAccess.revertAll();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Ed
    implements PieceEditor {
        private ImagePicker picker;
        private HotKeyConfigurer obscureKeyInput;
        private StringConfigurer obscureCommandInput;
        private StringConfigurer maskNameInput;
        private StringEnumConfigurer displayOption;
        private HotKeyConfigurer peekKeyInput;
        private JPanel controls = new JPanel();
        private String[] optionNames = new String[]{"Background", "Plain", "Inset", "Use Image"};
        private char[] optionChars = new char[]{'B', 'P', 'I', 'G'};
        private ImagePicker imagePicker;
        private PieceAccessConfigurer accessConfig;

        public Ed(Obscurable obscurable) {
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            Box box = Box.createHorizontalBox();
            this.obscureCommandInput = new StringConfigurer(null, "Mask Command:  ", obscurable.hideCommand);
            box.add(this.obscureCommandInput.getControls());
            this.obscureKeyInput = new HotKeyConfigurer(null, "Keyboard Command:  ", obscurable.keyCommand);
            box.add(this.obscureKeyInput.getControls());
            this.controls.add(box);
            this.accessConfig = new PieceAccessConfigurer(null, "Can be masked by:  ", obscurable.access);
            this.controls.add(this.accessConfig.getControls());
            box = Box.createHorizontalBox();
            box.add(new JLabel("View when masked: "));
            this.picker = new ImagePicker();
            this.picker.setImageName(obscurable.imageName);
            box.add(this.picker);
            this.controls.add(box);
            box = Box.createHorizontalBox();
            this.maskNameInput = new StringConfigurer(null, "Name when masked:  ", obscurable.maskName);
            box.add(this.maskNameInput.getControls());
            this.controls.add(box);
            box = Box.createHorizontalBox();
            this.displayOption = new StringEnumConfigurer(null, "Display style:  ", this.optionNames);
            for (int i = 0; i < this.optionNames.length; ++i) {
                if (obscurable.displayStyle != this.optionChars[i]) continue;
                this.displayOption.setValue(this.optionNames[i]);
                break;
            }
            box.add(this.displayOption.getControls());
            JPanel jPanel = new JPanel(this){
                private final /* synthetic */ Ed this$0;
                {
                    this.this$0 = ed;
                }

                public Dimension getMinimumSize() {
                    return new Dimension(60, 60);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(60, 60);
                }

                public void paint(Graphics graphics) {
                    graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
                    switch (Ed.access$000(this.this$0).getValueString().charAt(0)) {
                        case 'B': {
                            graphics.setColor(Color.black);
                            graphics.fillRect(0, 0, 60, 60);
                            graphics.setColor(Color.white);
                            graphics.fillRect(15, 15, 30, 30);
                            break;
                        }
                        case 'I': {
                            graphics.setColor(Color.white);
                            graphics.fillRect(0, 0, 60, 60);
                            graphics.setColor(Color.black);
                            graphics.fillRect(0, 0, 30, 30);
                            break;
                        }
                        case 'P': {
                            graphics.setColor(Color.black);
                            graphics.fillRect(0, 0, 60, 60);
                        }
                    }
                }
            };
            box.add(jPanel);
            this.controls.add(box);
            this.peekKeyInput = new HotKeyConfigurer(null, "Peek Command:  ", obscurable.peekKey);
            this.peekKeyInput.getControls().setVisible(obscurable.displayStyle == 'P');
            this.controls.add(this.peekKeyInput.getControls());
            this.imagePicker = new ImagePicker();
            this.imagePicker.setImageName(obscurable.obscuredToOthersImage);
            this.imagePicker.setVisible(obscurable.displayStyle == 'G');
            this.controls.add(this.imagePicker);
            this.displayOption.addPropertyChangeListener(new PropertyChangeListener(this, jPanel){
                private final /* synthetic */ JPanel val$showDisplayOption;
                private final /* synthetic */ Ed this$0;
                {
                    this.this$0 = ed;
                    this.val$showDisplayOption = jPanel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.val$showDisplayOption.repaint();
                    Ed.access$200(this.this$0).getControls().setVisible(Ed.access$100(this.this$0)[1].equals(propertyChangeEvent.getNewValue()));
                    Ed.access$300(this.this$0).setVisible(Ed.access$100(this.this$0)[3].equals(propertyChangeEvent.getNewValue()));
                    Window window = (Window)SwingUtilities.getAncestorOfClass(class$java$awt$Window == null ? (class$java$awt$Window = Obscurable.class$("java.awt.Window")) : class$java$awt$Window, Ed.access$400(this.this$0));
                    if (window != null) {
                        window.pack();
                    }
                }
            });
        }

        public String getState() {
            return "null";
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append((KeyStroke)this.obscureKeyInput.getValue()).append(this.picker.getImageName()).append(this.obscureCommandInput.getValueString());
            char c = 'I';
            for (int i = 0; i < this.optionNames.length; ++i) {
                if (!this.optionNames[i].equals(this.displayOption.getValueString())) continue;
                c = this.optionChars[i];
                break;
            }
            switch (c) {
                case 'P': {
                    String string = this.peekKeyInput.getValueString();
                    if (string != null) {
                        sequenceEncoder.append(c + string);
                        break;
                    }
                    sequenceEncoder.append(c);
                    break;
                }
                case 'G': {
                    sequenceEncoder.append(c + this.imagePicker.getImageName());
                    break;
                }
                default: {
                    sequenceEncoder.append(c);
                }
            }
            sequenceEncoder.append(this.maskNameInput.getValueString());
            sequenceEncoder.append(this.accessConfig.getValueString());
            return Obscurable.ID + sequenceEncoder.getValue();
        }

        public Component getControls() {
            return this.controls;
        }

        static /* synthetic */ StringEnumConfigurer access$000(Ed ed) {
            return ed.displayOption;
        }

        static /* synthetic */ String[] access$100(Ed ed) {
            return ed.optionNames;
        }

        static /* synthetic */ HotKeyConfigurer access$200(Ed ed) {
            return ed.peekKeyInput;
        }

        static /* synthetic */ ImagePicker access$300(Ed ed) {
            return ed.imagePicker;
        }

        static /* synthetic */ JPanel access$400(Ed ed) {
            return ed.controls;
        }
    }
}

