/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.Map;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitor;
import VASSAL.counters.DeckVisitorDispatcher;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Stack;
import java.awt.Point;
import java.awt.Shape;
import java.util.Enumeration;

public interface PieceFinder {
    public static final PieceFinder STACK_ONLY = new StackOnly();
    public static final PieceFinder PIECE_IN_STACK = new PieceInStack();
    public static final PieceFinder MOVABLE = new Movable();

    public GamePiece select(Map var1, GamePiece var2, Point var3);

    public static class Movable
    implements PieceFinder,
    DeckVisitor {
        protected Shape[] shapes = new Shape[0];
        protected Map map;
        protected Point pt;
        protected DeckVisitorDispatcher dispatcher = new DeckVisitorDispatcher(this);

        public Movable() {
            this(null, null);
        }

        public Movable(Map map, Point point) {
            this.map = map;
            this.pt = point;
        }

        public Object visitDeck(Deck deck) {
            return null;
        }

        public Object visitDefault(GamePiece gamePiece) {
            GamePiece gamePiece2 = null;
            Shape shape = gamePiece.getShape();
            Point point = gamePiece.getPosition();
            Point point2 = new Point(this.pt.x - point.x, this.pt.y - point.y);
            if (shape.contains(point2)) {
                gamePiece2 = gamePiece;
            }
            return gamePiece2;
        }

        public Object visitStack(Stack stack) {
            GamePiece gamePiece = null;
            if (this.shapes.length < stack.getPieceCount()) {
                this.shapes = new Shape[stack.getPieceCount()];
            }
            this.map.getStackMetrics().getContents(stack, null, this.shapes, null, stack.getPosition().x, stack.getPosition().y);
            Enumeration enumeration = stack.getPiecesInVisibleOrder();
            while (enumeration.hasMoreElements()) {
                GamePiece gamePiece2 = (GamePiece)enumeration.nextElement();
                if (!this.shapes[stack.indexOf(gamePiece2)].contains(this.pt)) continue;
                gamePiece = stack.isExpanded() ? gamePiece2 : stack;
                break;
            }
            return gamePiece;
        }

        public GamePiece select(Map map, GamePiece gamePiece, Point point) {
            this.map = map;
            this.pt = point;
            return (GamePiece)this.dispatcher.accept(gamePiece);
        }
    }

    public static class PieceInStack
    extends Movable {
        public Object visitStack(Stack stack) {
            GamePiece gamePiece = (GamePiece)super.visitStack(stack);
            if (gamePiece == stack && !stack.isExpanded()) {
                gamePiece = stack.topPiece();
            }
            return gamePiece;
        }
    }

    public static class StackOnly
    extends Movable {
        public Object visitDefault(GamePiece gamePiece) {
            return null;
        }

        public Object visitStack(Stack stack) {
            GamePiece gamePiece = (GamePiece)super.visitStack(stack);
            if (gamePiece != null && gamePiece.getParent() == stack) {
                gamePiece = stack;
            }
            return gamePiece;
        }
    }
}

