/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceFilter;
import java.util.Enumeration;
import java.util.Iterator;

public class PieceIterator {
    private Enumeration e;
    private PieceFilter filter;
    private GamePiece next;

    public PieceIterator(Enumeration enumeration) {
        this(enumeration, null);
    }

    public PieceIterator(Enumeration enumeration, PieceFilter pieceFilter) {
        this(pieceFilter);
        this.e = enumeration;
        this.next = this.next();
    }

    public PieceIterator(PieceFilter pieceFilter) {
        this.filter = pieceFilter;
    }

    public PieceIterator(final Iterator iterator) {
        this(new Enumeration(){

            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            public Object nextElement() {
                return iterator.next();
            }
        });
    }

    private GamePiece next() {
        while (this.e.hasMoreElements()) {
            Object e = this.e.nextElement();
            if (!(e instanceof GamePiece) || this.filter != null && !this.filter.accept((GamePiece)e)) continue;
            return (GamePiece)e;
        }
        return null;
    }

    public GamePiece nextPiece() {
        GamePiece gamePiece = this.next;
        this.next = this.next();
        return gamePiece;
    }

    public boolean hasMoreElements() {
        return this.next != null;
    }

    public static PieceIterator visible(Enumeration enumeration) {
        return new PieceIterator(enumeration, new PieceFilter(){

            public boolean accept(GamePiece gamePiece) {
                return !Boolean.TRUE.equals(gamePiece.getProperty("Invisible"));
            }
        });
    }
}

