/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.MovementReporter;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.command.MoveTracker;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.DoubleConfigurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.FreeRotator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class Pivot
extends Decorator
implements EditablePiece {
    public static final String ID = "pivot;";
    public static final String DEGREES = "_Degrees";
    protected int pivotX;
    protected int pivotY;
    protected double angle;
    protected String command;
    protected KeyStroke key;
    protected boolean fixedAngle;
    protected KeyCommand[] commands;
    protected KeyCommand pivotCommand;
    protected FreeRotator rotator;
    static /* synthetic */ Class class$VASSAL$counters$FreeRotator;

    public Pivot() {
        this(ID, null);
    }

    public Pivot(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    public String getDescription() {
        return "Can Pivot";
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Pivot.htm");
    }

    public void mySetType(String string) {
        string = string.substring(ID.length());
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        this.command = decoder.nextToken("Pivot");
        this.key = decoder.nextKeyStroke(null);
        this.pivotX = decoder.nextInt(0);
        this.pivotY = decoder.nextInt(0);
        this.fixedAngle = decoder.nextBoolean(true);
        this.angle = decoder.nextDouble(90.0);
        this.commands = null;
    }

    protected KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            this.pivotCommand = new KeyCommand(this.command, this.key, Decorator.getOutermost(this));
            this.commands = this.command.length() > 0 ? new KeyCommand[]{this.pivotCommand} : new KeyCommand[0];
            this.rotator = (FreeRotator)Decorator.getDecorator(this, class$VASSAL$counters$FreeRotator == null ? (class$VASSAL$counters$FreeRotator = Pivot.class$("VASSAL.counters.FreeRotator")) : class$VASSAL$counters$FreeRotator);
            this.pivotCommand.setEnabled(this.rotator != null);
        }
        return this.commands;
    }

    public String myGetState() {
        return "";
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.command).append(this.key).append(this.pivotX).append(this.pivotY).append(this.fixedAngle).append(this.angle);
        return ID + sequenceEncoder.getValue();
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        this.myGetKeyCommands();
        Command command = null;
        if (this.pivotCommand.matches(keyStroke)) {
            if (this.fixedAngle) {
                ChangeTracker changeTracker = new ChangeTracker(this);
                double d = this.rotator.getAngle();
                this.rotator.setAngle(d - this.angle);
                double d2 = this.rotator.getAngle();
                if (this.getMap() != null) {
                    Point point = this.getPosition();
                    this.pivotPoint(point, -Math.PI * d / 180.0, -Math.PI * d2 / 180.0);
                    GamePiece gamePiece = Decorator.getOutermost(this);
                    if (!Boolean.TRUE.equals(gamePiece.getProperty("IgnoreGrid"))) {
                        point = this.getMap().snapTo(point);
                    }
                    gamePiece.setProperty("Moved", Boolean.TRUE);
                    command = changeTracker.getChangeCommand();
                    MoveTracker moveTracker = new MoveTracker(gamePiece);
                    this.getMap().placeOrMerge(gamePiece, point);
                    command = command.append(moveTracker.getMoveCommand());
                    MovementReporter movementReporter = new MovementReporter(command);
                    Command command2 = movementReporter.getReportCommand();
                    if (command2 != null) {
                        command2.execute();
                    }
                    command = command.append(command2);
                    command = command.append(movementReporter.markMovedPieces());
                    this.getMap().ensureVisible(this.getMap().selectionBoundsOf(gamePiece));
                } else {
                    command = changeTracker.getChangeCommand();
                }
            } else if (this.getMap() != null) {
                double d = this.rotator.getAngleInRadians();
                Point2D.Double double_ = new Point2D.Double(this.pivotX, this.pivotY);
                AffineTransform affineTransform = AffineTransform.getRotateInstance(d);
                affineTransform.transform(double_, double_);
                this.rotator.beginInteractiveRotate();
                this.rotator.setPivot(this.getPosition().x + (int)Math.round(((Point2D)double_).getX()), this.getPosition().y + (int)Math.round(((Point2D)double_).getY()));
            }
        }
        if (command != null && this.getMap() != null && this.getMap().getMoveKey() != null) {
            command.append(Decorator.getOutermost(this).keyEvent(this.getMap().getMoveKey()));
        }
        return command;
    }

    private void pivotPoint(Point point, double d, double d2) {
        Point2D.Double double_ = new Point2D.Double(this.pivotX, this.pivotY);
        AffineTransform affineTransform = AffineTransform.getRotateInstance(d);
        affineTransform.transform(double_, double_);
        affineTransform = AffineTransform.getRotateInstance(d2 - d, ((Point2D)double_).getX(), ((Point2D)double_).getY());
        Point2D.Float float_ = new Point2D.Float(0.0f, 0.0f);
        affineTransform.transform(float_, float_);
        point.x += (int)Math.round(((Point2D)float_).getX());
        point.y += (int)Math.round(((Point2D)float_).getY());
    }

    public void mySetState(String string) {
    }

    public Rectangle boundingBox() {
        return this.getInner().boundingBox();
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.getInner().draw(graphics, n, n2, component, d);
    }

    public String getName() {
        return this.getInner().getName();
    }

    public Shape getShape() {
        return this.getInner().getShape();
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Ed
    implements PieceEditor {
        private StringConfigurer command;
        private HotKeyConfigurer key;
        private IntConfigurer xOff;
        private IntConfigurer yOff;
        private DoubleConfigurer angle;
        private BooleanConfigurer fixedAngle;
        private JPanel controls = new JPanel();

        public Ed(Pivot pivot) {
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            this.command = new StringConfigurer(null, "Command:  ", pivot.command);
            this.controls.add(this.command.getControls());
            this.key = new HotKeyConfigurer(null, "Keyboard command:  ", pivot.key);
            this.controls.add(this.key.getControls());
            Box box = Box.createHorizontalBox();
            this.xOff = new IntConfigurer(null, "Pivot point:  ", new Integer(pivot.pivotX));
            box.add(this.xOff.getControls());
            this.yOff = new IntConfigurer(null, ", ", new Integer(pivot.pivotY));
            box.add(this.yOff.getControls());
            this.controls.add(box);
            this.fixedAngle = new BooleanConfigurer(null, "Pivot through fixed angle", new Boolean(pivot.fixedAngle));
            this.controls.add(this.fixedAngle.getControls());
            this.angle = new DoubleConfigurer(null, "Angle:  ", new Double(pivot.angle));
            this.controls.add(this.angle.getControls());
            this.angle.getControls().setVisible(pivot.fixedAngle);
            this.fixedAngle.addPropertyChangeListener(new PropertyChangeListener(this){
                private final /* synthetic */ Ed this$0;
                {
                    this.this$0 = ed;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Ed.access$100(this.this$0).getControls().setVisible(Boolean.TRUE.equals(Ed.access$000(this.this$0).getValue()));
                }
            });
        }

        public Component getControls() {
            return this.controls;
        }

        public String getState() {
            return "";
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(this.command.getValueString()).append((KeyStroke)this.key.getValue()).append(this.xOff.getValueString()).append(this.yOff.getValueString()).append(Boolean.TRUE.equals(this.fixedAngle.getValue())).append(this.angle.getValueString());
            return Pivot.ID + sequenceEncoder.getValue();
        }

        static /* synthetic */ BooleanConfigurer access$000(Ed ed) {
            return ed.fixedAngle;
        }

        static /* synthetic */ DoubleConfigurer access$100(Ed ed) {
            return ed.angle;
        }
    }
}

