/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.widget.PieceSlot;
import VASSAL.command.AddPiece;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ChooseComponentPathDialog;
import VASSAL.configure.ConfigurerWindow;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.FreeRotator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceCloner;
import VASSAL.counters.PieceEditor;
import VASSAL.tools.ComponentPathBuilder;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class PlaceMarker
extends Decorator
implements EditablePiece {
    public static final String ID = "placemark;";
    protected KeyCommand command;
    protected KeyStroke key;
    protected String markerSpec;
    protected String markerText = "";
    protected int xOffset = 0;
    protected int yOffset = 0;
    protected boolean matchRotation = false;
    protected KeyCommand[] commands;
    protected KeyStroke afterBurnerKey;
    protected String description = "";
    static /* synthetic */ Class class$VASSAL$counters$FreeRotator;
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$VASSAL$build$widget$PieceSlot;
    static /* synthetic */ Class class$VASSAL$build$widget$CardSlot;

    public PlaceMarker() {
        this("placemark;Place Marker;M;null;null;null", null);
    }

    public PlaceMarker(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.piece.draw(graphics, n, n2, component, d);
    }

    public String getName() {
        return this.piece.getName();
    }

    protected KeyCommand[] myGetKeyCommands() {
        this.command.setEnabled(this.getMap() != null && this.markerSpec != null);
        return this.commands;
    }

    public String myGetState() {
        return "";
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.command.getName());
        sequenceEncoder.append(this.key);
        sequenceEncoder.append(this.markerSpec == null ? "null" : this.markerSpec);
        sequenceEncoder.append(this.markerText == null ? "null" : this.markerText);
        sequenceEncoder.append(this.xOffset).append(this.yOffset);
        sequenceEncoder.append(this.matchRotation);
        sequenceEncoder.append(this.afterBurnerKey);
        sequenceEncoder.append(this.description);
        return ID + sequenceEncoder.getValue();
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        this.myGetKeyCommands();
        if (this.command.matches(keyStroke)) {
            return this.placeMarker();
        }
        return null;
    }

    protected Command placeMarker() {
        GamePiece gamePiece = this.createMarker();
        Object object = null;
        if (gamePiece != null) {
            Object object2;
            Object object3;
            GamePiece gamePiece2 = Decorator.getOutermost(this);
            Point point = this.getPosition();
            point.translate(this.xOffset, -this.yOffset);
            if (this.matchRotation) {
                object3 = (FreeRotator)Decorator.getDecorator(gamePiece2, class$VASSAL$counters$FreeRotator == null ? (class$VASSAL$counters$FreeRotator = PlaceMarker.class$("VASSAL.counters.FreeRotator")) : class$VASSAL$counters$FreeRotator);
                object2 = (FreeRotator)Decorator.getDecorator(gamePiece, class$VASSAL$counters$FreeRotator == null ? (class$VASSAL$counters$FreeRotator = PlaceMarker.class$("VASSAL.counters.FreeRotator")) : class$VASSAL$counters$FreeRotator);
                if (object3 != null && object2 != null) {
                    ((FreeRotator)object2).setAngle(((FreeRotator)object3).getAngle());
                    Point point2 = this.getPosition().getLocation();
                    Point2D point2D = point.getLocation();
                    point2D = AffineTransform.getRotateInstance(((FreeRotator)object3).getAngleInRadians(), ((Point2D)point2).getX(), ((Point2D)point2).getY()).transform(point2D, null);
                    point = new Point((int)point2D.getX(), (int)point2D.getY());
                }
            }
            if (!Boolean.TRUE.equals(gamePiece.getProperty("IgnoreGrid"))) {
                point = this.getMap().snapTo(point);
            }
            object = this.getMap().placeOrMerge(gamePiece, point);
            if (this.afterBurnerKey != null) {
                gamePiece.setProperty("snapshot", PieceCloner.getInstance().clonePiece(gamePiece));
                ((Command)object).append(gamePiece.keyEvent(this.afterBurnerKey));
            }
            if (gamePiece.getProperty("selectEventFilter") == null) {
                KeyBuffer.getBuffer().remove(gamePiece2);
                KeyBuffer.getBuffer().add(gamePiece);
            }
            if (!(this.markerText == null || this.getMap() == null || Boolean.TRUE.equals(gamePiece2.getProperty("ObscuredToOthers")) || Boolean.TRUE.equals(gamePiece2.getProperty("Obscured")) || Boolean.TRUE.equals(gamePiece2.getProperty("InvisibleToOthers")) || (object3 = this.getMap().locationName(this.getPosition())) == null)) {
                object2 = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), " * " + (String)object3 + ":  " + gamePiece2.getName() + " " + this.markerText + " * ");
                ((Command)object2).execute();
                object = object == null ? object2 : ((Command)object).append((Command)object2);
            }
        }
        return object;
    }

    protected GamePiece createMarker() {
        GamePiece gamePiece = this.createBaseMarker();
        gamePiece = gamePiece == null ? new BasicPiece() : PieceCloner.getInstance().clonePiece(gamePiece);
        return gamePiece;
    }

    protected GamePiece createBaseMarker() {
        if (this.markerSpec == null) {
            return null;
        }
        GamePiece gamePiece = null;
        if (this.markerSpec.startsWith("+/")) {
            AddPiece addPiece = (AddPiece)GameModule.getGameModule().decode(this.markerSpec);
            gamePiece = addPiece.getTarget();
            gamePiece.setState(addPiece.getState());
        } else {
            try {
                Configurable[] configurableArray = ComponentPathBuilder.getInstance().getPath(this.markerSpec);
                if (configurableArray[configurableArray.length - 1] instanceof PieceSlot) {
                    gamePiece = ((PieceSlot)configurableArray[configurableArray.length - 1]).getPiece();
                }
            }
            catch (ComponentPathBuilder.PathFormatException pathFormatException) {
                // empty catch block
            }
        }
        return gamePiece;
    }

    public void mySetState(String string) {
    }

    public Shape getShape() {
        return this.piece.getShape();
    }

    public String getDescription() {
        String string = "Place Marker";
        if (this.description.length() > 0) {
            string = string + " - " + this.description;
        }
        return string;
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Marker.htm");
    }

    public void mySetType(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        decoder.nextToken();
        String string2 = decoder.nextToken();
        this.key = decoder.nextKeyStroke(null);
        this.command = new KeyCommand(string2, this.key, this);
        this.commands = string2.length() > 0 && this.key != null ? new KeyCommand[]{this.command} : new KeyCommand[0];
        this.markerSpec = decoder.nextToken();
        if ("null".equals(this.markerSpec)) {
            this.markerSpec = null;
        }
        this.markerText = decoder.nextToken("null");
        if ("null".equals(this.markerText)) {
            this.markerText = null;
        }
        this.xOffset = decoder.nextInt(0);
        this.yOffset = decoder.nextInt(0);
        this.matchRotation = decoder.nextBoolean(false);
        this.afterBurnerKey = decoder.nextKeyStroke(null);
        this.description = decoder.nextToken("");
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class Ed
    implements PieceEditor {
        private HotKeyConfigurer keyInput;
        private StringConfigurer commandInput;
        private PieceSlot pieceInput;
        private JPanel p = new JPanel();
        private String markerSlotPath;
        protected JButton defineButton = new JButton("Define Marker");
        protected JButton selectButton = new JButton("Select");
        protected IntConfigurer xOffsetConfig = new IntConfigurer(null, "Horizontal offset:  ");
        protected IntConfigurer yOffsetConfig = new IntConfigurer(null, "Vertical offset:  ");
        protected BooleanConfigurer matchRotationConfig = this.createMatchRotationConfig();
        protected HotKeyConfigurer afterBurner;
        protected StringConfigurer descConfig;

        protected Ed(PlaceMarker placeMarker) {
            this.descConfig = new StringConfigurer(null, "Description:  ", placeMarker.description);
            this.keyInput = new HotKeyConfigurer(null, "Keyboard Command:  ", placeMarker.key);
            this.afterBurner = new HotKeyConfigurer(null, "Keystroke to apply after placement:  ", placeMarker.afterBurnerKey);
            this.commandInput = new StringConfigurer(null, "Command: ", placeMarker.command.getName());
            GamePiece gamePiece = placeMarker.createBaseMarker();
            this.pieceInput = new PieceSlot(gamePiece);
            this.markerSlotPath = placeMarker.markerSpec;
            this.p = new JPanel();
            this.p.setLayout(new BoxLayout(this.p, 1));
            this.p.add(this.descConfig.getControls());
            this.p.add(this.commandInput.getControls());
            this.p.add(this.keyInput.getControls());
            Box box = Box.createHorizontalBox();
            box.add(this.pieceInput.getComponent());
            this.defineButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ Ed this$0;
                {
                    this.this$0 = ed;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Ed.access$002(this.this$0, null);
                    ((Component)new ConfigurerWindow(Ed.access$100(this.this$0).getConfigurer())).setVisible(true);
                }
            });
            box.add(this.defineButton);
            this.selectButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ Ed this$0;
                {
                    this.this$0 = ed;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ChoosePieceDialog choosePieceDialog = new ChoosePieceDialog((Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = PlaceMarker.class$("java.awt.Frame")) : class$java$awt$Frame, Ed.access$200(this.this$0)), class$VASSAL$build$widget$PieceSlot == null ? (class$VASSAL$build$widget$PieceSlot = PlaceMarker.class$("VASSAL.build.widget.PieceSlot")) : class$VASSAL$build$widget$PieceSlot);
                    ((Component)choosePieceDialog).setVisible(true);
                    if (choosePieceDialog.getTarget() instanceof PieceSlot) {
                        Ed.access$100(this.this$0).setPiece(((PieceSlot)choosePieceDialog.getTarget()).getPiece());
                    }
                    if (choosePieceDialog.getPath() != null) {
                        Ed.access$002(this.this$0, ComponentPathBuilder.getInstance().getId(choosePieceDialog.getPath()));
                    } else {
                        Ed.access$002(this.this$0, null);
                    }
                }
            });
            box.add(this.selectButton);
            this.p.add(box);
            this.xOffsetConfig.setValue(new Integer(placeMarker.xOffset));
            this.p.add(this.xOffsetConfig.getControls());
            this.yOffsetConfig.setValue(new Integer(placeMarker.yOffset));
            this.p.add(this.yOffsetConfig.getControls());
            this.matchRotationConfig.setValue(new Boolean(placeMarker.matchRotation));
            this.p.add(this.matchRotationConfig.getControls());
            this.p.add(this.afterBurner.getControls());
        }

        protected BooleanConfigurer createMatchRotationConfig() {
            return new BooleanConfigurer(null, "Match Rotation");
        }

        public Component getControls() {
            return this.p;
        }

        public String getState() {
            return "";
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(this.commandInput.getValueString());
            sequenceEncoder.append((KeyStroke)this.keyInput.getValue());
            if (this.pieceInput.getPiece() == null) {
                sequenceEncoder.append("null");
            } else if (this.markerSlotPath != null) {
                sequenceEncoder.append(this.markerSlotPath);
            } else {
                String string = GameModule.getGameModule().encode(new AddPiece(this.pieceInput.getPiece()));
                sequenceEncoder.append(string);
            }
            sequenceEncoder.append("null");
            sequenceEncoder.append(this.xOffsetConfig.getValueString());
            sequenceEncoder.append(this.yOffsetConfig.getValueString());
            sequenceEncoder.append(this.matchRotationConfig.getValueString());
            sequenceEncoder.append((KeyStroke)this.afterBurner.getValue());
            sequenceEncoder.append(this.descConfig.getValueString());
            return PlaceMarker.ID + sequenceEncoder.getValue();
        }

        static /* synthetic */ String access$002(Ed ed, String string) {
            ed.markerSlotPath = string;
            return ed.markerSlotPath;
        }

        static /* synthetic */ PieceSlot access$100(Ed ed) {
            return ed.pieceInput;
        }

        static /* synthetic */ JPanel access$200(Ed ed) {
            return ed.p;
        }

        public static class ChoosePieceDialog
        extends ChooseComponentPathDialog {
            public ChoosePieceDialog(Frame frame, Class clazz) {
                super(frame, clazz);
            }

            protected boolean isValidTarget(Object object) {
                return super.isValidTarget(object) || (class$VASSAL$build$widget$CardSlot == null ? (class$VASSAL$build$widget$CardSlot = PlaceMarker.class$("VASSAL.build.widget.CardSlot")) : class$VASSAL$build$widget$CardSlot).isInstance(object);
            }
        }
    }
}

