/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.counters.BooleanAndPieceFilter;
import VASSAL.counters.BooleanOrPieceFilter;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceFilter;
import java.util.regex.Pattern;

public class PropertiesPieceFilter {
    private static final Pattern[] CONDITIONS = new Pattern[]{Pattern.compile("!="), Pattern.compile("<="), Pattern.compile(">="), Pattern.compile(">"), Pattern.compile("<"), Pattern.compile("=~"), Pattern.compile("="), Pattern.compile("!~")};
    private static final Pattern AND = Pattern.compile("&&");
    private static final Pattern OR = Pattern.compile("\\|\\|");
    private static PieceFilter NULL_FILTER = new PieceFilter(){

        public boolean accept(GamePiece gamePiece) {
            return false;
        }
    };

    public static PieceFilter parse(String string) {
        if (string == null || string.length() == 0) {
            return NULL_FILTER;
        }
        String[] stringArray = OR.split(string);
        PieceFilter pieceFilter = null;
        if (stringArray.length > 1) {
            pieceFilter = PropertiesPieceFilter.parse(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                pieceFilter = new BooleanOrPieceFilter(pieceFilter, PropertiesPieceFilter.parse(stringArray[i]));
            }
        } else {
            stringArray = AND.split(string);
            if (stringArray.length > 1) {
                pieceFilter = PropertiesPieceFilter.parse(stringArray[0]);
                for (int i = 1; i < stringArray.length; ++i) {
                    pieceFilter = new BooleanAndPieceFilter(pieceFilter, PropertiesPieceFilter.parse(stringArray[i]));
                }
            } else {
                for (int i = 0; i < CONDITIONS.length && pieceFilter == null; ++i) {
                    if (string.indexOf(CONDITIONS[i].pattern()) < 0) continue;
                    stringArray = CONDITIONS[i].split(string);
                    String string2 = "";
                    String string3 = "";
                    if (stringArray.length <= 0) break;
                    string2 = stringArray[0].trim();
                    if (stringArray.length > 1) {
                        string3 = stringArray[1].trim();
                    }
                    switch (i) {
                        case 0: {
                            pieceFilter = new NE(string2, string3);
                            break;
                        }
                        case 1: {
                            pieceFilter = new LE(string2, string3);
                            break;
                        }
                        case 2: {
                            pieceFilter = new GE(string2, string3);
                            break;
                        }
                        case 3: {
                            pieceFilter = new GT(string2, string3);
                            break;
                        }
                        case 4: {
                            pieceFilter = new LT(string2, string3);
                            break;
                        }
                        case 5: {
                            pieceFilter = new MATCH(string2, string3);
                            break;
                        }
                        case 6: {
                            pieceFilter = new EQ(string2, string3);
                            break;
                        }
                        case 7: {
                            pieceFilter = new NOT_MATCH(string2, string3);
                        }
                    }
                    break;
                }
                if (pieceFilter == null) {
                    pieceFilter = NULL_FILTER;
                }
            }
        }
        return pieceFilter;
    }

    private static class NOT_MATCH
    extends MATCH {
        public NOT_MATCH(String string, String string2) {
            super(string, string2);
        }

        public boolean accept(GamePiece gamePiece) {
            return !super.accept(gamePiece);
        }

        public String toString() {
            return "PropertiesPieceFilter[" + this.name + "!~" + this.value + "]";
        }
    }

    private static class MATCH
    extends ComparisonFilter {
        public MATCH(String string, String string2) {
            super(string, string2);
        }

        public boolean accept(GamePiece gamePiece) {
            String string = String.valueOf(gamePiece.getProperty(this.name));
            return Pattern.matches(this.value, string);
        }

        public String toString() {
            return "PropertiesPieceFilter[" + this.name + "~" + this.value + "]";
        }
    }

    private static class GE
    extends ComparisonFilter {
        public GE(String string, String string2) {
            super(string, string2);
        }

        public boolean accept(GamePiece gamePiece) {
            return this.compareTo(gamePiece) >= 0;
        }

        public String toString() {
            return "PropertiesPieceFilter[" + this.name + ">=" + this.value + "]";
        }
    }

    private static class GT
    extends ComparisonFilter {
        public GT(String string, String string2) {
            super(string, string2);
        }

        public boolean accept(GamePiece gamePiece) {
            return this.compareTo(gamePiece) > 0;
        }

        public String toString() {
            return "PropertiesPieceFilter[" + this.name + ">" + this.value + "]";
        }
    }

    private static class LE
    extends ComparisonFilter {
        public LE(String string, String string2) {
            super(string, string2);
        }

        public boolean accept(GamePiece gamePiece) {
            return this.compareTo(gamePiece) <= 0;
        }

        public String toString() {
            return "PropertiesPieceFilter[" + this.name + "<=" + this.value + "]";
        }
    }

    private static class LT
    extends ComparisonFilter {
        public LT(String string, String string2) {
            super(string, string2);
        }

        public boolean accept(GamePiece gamePiece) {
            return this.compareTo(gamePiece) < 0;
        }

        public String toString() {
            return "PropertiesPieceFilter[" + this.name + "<" + this.value + "]";
        }
    }

    private static class NE
    extends ComparisonFilter {
        public NE(String string, String string2) {
            super(string, string2);
        }

        public boolean accept(GamePiece gamePiece) {
            boolean bl;
            String string = String.valueOf(gamePiece.getProperty(this.name));
            boolean bl2 = bl = !this.value.equals(string);
            if (this.alternate != null) {
                bl = bl && !this.alternate.equals(string);
            }
            return bl;
        }

        public String toString() {
            return "PropertiesPieceFilter[" + this.name + "!=" + this.value + "]";
        }
    }

    private static class EQ
    extends ComparisonFilter {
        public EQ(String string, String string2) {
            super(string, string2);
        }

        public boolean accept(GamePiece gamePiece) {
            String string = String.valueOf(gamePiece.getProperty(this.name));
            boolean bl = this.value.equals(string);
            if (this.alternate != null) {
                bl = bl || this.alternate.equals(string);
            }
            return bl;
        }

        public String toString() {
            return "PropertiesPieceFilter[" + this.name + "==" + this.value + "]";
        }
    }

    private static abstract class ComparisonFilter
    implements PieceFilter {
        protected String name;
        protected String value;
        protected Object alternate;

        public ComparisonFilter(String string, String string2) {
            this.name = string;
            this.value = string2;
            if ("true".equals(string2)) {
                this.alternate = Boolean.TRUE;
            } else if ("false".equals(string2)) {
                this.alternate = Boolean.FALSE;
            }
        }

        protected int compareTo(GamePiece gamePiece) {
            String string = String.valueOf(gamePiece.getProperty(this.name));
            try {
                return Integer.valueOf(string).compareTo(Integer.valueOf(this.value));
            }
            catch (NumberFormatException numberFormatException) {
                return string.compareTo(this.value);
            }
        }

        public abstract /* synthetic */ boolean accept(GamePiece var1);
    }
}

