/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.KeyStroke;

public class Restricted
extends Decorator
implements EditablePiece {
    public static final String ID = "restrict;";
    private String[] side;

    public Restricted() {
        this(ID, null);
    }

    public Restricted(String string, GamePiece gamePiece) {
        this.setInner(gamePiece);
        this.mySetType(string);
    }

    public String getDescription() {
        return "Restricted Access";
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("RestrictedAccess.htm");
    }

    public void mySetType(String string) {
        string = string.substring(ID.length());
        this.side = StringArrayConfigurer.stringToArray(string);
    }

    public Shape getShape() {
        return this.piece.getShape();
    }

    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.piece.draw(graphics, n, n2, component, d);
    }

    public String getName() {
        return this.piece.getName();
    }

    protected KeyCommand[] myGetKeyCommands() {
        return new KeyCommand[0];
    }

    public boolean isRestricted() {
        if (PlayerRoster.isActive() && GameModule.getGameModule().getGameState().isGameStarted()) {
            for (int i = 0; i < this.side.length; ++i) {
                if (!this.side[i].equals(PlayerRoster.getMySide())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected KeyCommand[] getKeyCommands() {
        if (!this.isRestricted()) {
            return super.getKeyCommands();
        }
        return new KeyCommand[0];
    }

    public Object getProperty(Object object) {
        if ("Restricted".equals(object)) {
            return new Boolean(this.isRestricted());
        }
        return super.getProperty(object);
    }

    public String myGetState() {
        return "";
    }

    public String myGetType() {
        return ID + StringArrayConfigurer.arrayToString(this.side);
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        return null;
    }

    public Command keyEvent(KeyStroke keyStroke) {
        if (!this.isRestricted()) {
            return super.keyEvent(keyStroke);
        }
        return null;
    }

    public void mySetState(String string) {
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    public static class Ed
    implements PieceEditor {
        private StringArrayConfigurer config;

        public Ed(Restricted restricted) {
            this.config = new StringArrayConfigurer(null, "Belongs to side", restricted.side);
        }

        public Component getControls() {
            return this.config.getControls();
        }

        public String getState() {
            return "";
        }

        public String getType() {
            return Restricted.ID + this.config.getValueString();
        }
    }
}

