/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.DrawPile;
import VASSAL.command.Command;
import VASSAL.configure.ChooseComponentDialog;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.UniqueIdManager;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class ReturnToDeck
extends Decorator
implements EditablePiece {
    public static final String ID = "return;";
    protected String deckId;
    protected String returnCommand;
    protected KeyStroke returnKey;
    protected DrawPile deck;
    protected KeyCommand[] commands;
    protected KeyCommand myCommand;
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$VASSAL$build$module$map$DrawPile;

    public ReturnToDeck() {
        this("return;Return to Deck;R;null", null);
    }

    public ReturnToDeck(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    protected KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            this.myCommand = new KeyCommand(this.returnCommand, this.returnKey, Decorator.getOutermost(this));
            this.commands = this.returnCommand.length() > 0 && this.returnKey != null ? new KeyCommand[]{this.myCommand} : new KeyCommand[0];
        }
        return this.commands;
    }

    public String myGetState() {
        return "";
    }

    public void mySetType(String string) {
        string = string.substring(ID.length());
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        this.returnCommand = decoder.nextToken();
        this.returnKey = decoder.nextKeyStroke(null);
        this.deckId = decoder.nextToken();
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        return ID + sequenceEncoder.append(this.returnCommand).append(this.returnKey).append(this.deckId).getValue();
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        this.myGetKeyCommands();
        Command command = null;
        if (this.myCommand.matches(keyStroke)) {
            if (this.deck == null) {
                this.findDeck();
            }
            command = this.deck.addToContents(Decorator.getOutermost(this));
            Map map = this.deck.getMap();
            if (map != null && map.getMoveKey() != null) {
                command.append(Decorator.getOutermost(this).keyEvent(map.getMoveKey()));
            }
            this.deck.getMap().repaint();
        }
        return command;
    }

    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.piece.draw(graphics, n, n2, component, d);
    }

    public String getName() {
        return this.piece.getName();
    }

    public Shape getShape() {
        return this.piece.getShape();
    }

    private void findDeck() {
        DrawPile drawPile = DrawPile.findDrawPile(this.deckId);
        if (drawPile == null) {
            throw new IllegalArgumentException("Could not find deck " + this.deckId);
        }
        this.deck = drawPile;
    }

    public void mySetState(String string) {
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    public String getDescription() {
        String string = "Return to Deck";
        if (this.deck != null) {
            this.findDeck();
            if (this.deck != null) {
                string = string + " - " + this.deck.getConfigureName();
            }
        }
        return string;
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ReturnToDeck.htm");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Ed
    implements PieceEditor {
        private StringConfigurer menuName;
        private HotKeyConfigurer menuKey;
        private JPanel controls;
        private String deckId;
        private final JTextField tf = new JTextField(12);

        public Ed(ReturnToDeck returnToDeck) {
            this.controls = new JPanel();
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            this.menuName = new StringConfigurer(null, "Menu Text:  ", returnToDeck.returnCommand);
            this.controls.add(this.menuName.getControls());
            this.menuKey = new HotKeyConfigurer(null, "Keyboard Command:  ", returnToDeck.returnKey);
            this.deckId = returnToDeck.deckId;
            this.controls.add(this.menuKey.getControls());
            JButton jButton = new JButton("Select Deck");
            this.tf.setEditable(false);
            this.updateDeckName();
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ Ed this$0;
                {
                    this.this$0 = ed;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ChooseComponentDialog chooseComponentDialog = new ChooseComponentDialog((Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = ReturnToDeck.class$("java.awt.Frame")) : class$java$awt$Frame, Ed.access$000(this.this$0)), class$VASSAL$build$module$map$DrawPile == null ? (class$VASSAL$build$module$map$DrawPile = ReturnToDeck.class$("VASSAL.build.module.map.DrawPile")) : class$VASSAL$build$module$map$DrawPile);
                    chooseComponentDialog.setTitle("Select Deck");
                    ((Component)chooseComponentDialog).setVisible(true);
                    if (chooseComponentDialog.getTarget() != null) {
                        Ed.access$102(this.this$0, UniqueIdManager.getIdentifier((UniqueIdManager.Identifyable)((Object)chooseComponentDialog.getTarget())));
                        Ed.access$200(this.this$0);
                    }
                }
            });
            Box box = Box.createHorizontalBox();
            box.add(jButton);
            box.add(this.tf);
            this.controls.add(box);
        }

        private void updateDeckName() {
            DrawPile drawPile = DrawPile.findDrawPile(this.deckId);
            this.tf.setText(drawPile != null ? drawPile.getConfigureName() : "<none>");
        }

        public Component getControls() {
            return this.controls;
        }

        public String getState() {
            return "";
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            return ReturnToDeck.ID + sequenceEncoder.append(this.menuName.getValueString()).append((KeyStroke)this.menuKey.getValue()).append(this.deckId).getValue();
        }

        static /* synthetic */ JPanel access$000(Ed ed) {
            return ed.controls;
        }

        static /* synthetic */ String access$102(Ed ed, String string) {
            ed.deckId = string;
            return ed.deckId;
        }

        static /* synthetic */ void access$200(Ed ed) {
            ed.updateDeckName();
        }
    }
}

