/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ChooseComponentDialog;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.Stack;
import VASSAL.tools.FormattedString;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class SendToLocation
extends Decorator
implements EditablePiece {
    public static final String ID = "sendto;";
    public static final String BACK_MAP = "backMap";
    public static final String BACK_POINT = "backPoint";
    protected KeyCommand[] command;
    protected String commandName;
    protected String backCommandName;
    protected KeyStroke key;
    protected KeyStroke backKey;
    protected String mapId;
    protected String boardName;
    protected FormattedString x = new FormattedString("");
    protected FormattedString xIndex = new FormattedString("");
    protected FormattedString xOffset = new FormattedString("");
    protected FormattedString y = new FormattedString("");
    protected FormattedString yIndex = new FormattedString("");
    protected FormattedString yOffset = new FormattedString("");
    protected KeyCommand sendCommand;
    protected KeyCommand backCommand;
    protected String description;
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$VASSAL$build$module$map$boardPicker$Board;
    static /* synthetic */ Class class$VASSAL$build$module$Map;

    public SendToLocation() {
        this("sendto;;;;;0;0;;", null);
    }

    public SendToLocation(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    public void mySetType(String string) {
        string = string.substring(ID.length());
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        this.commandName = decoder.nextToken();
        this.key = decoder.nextKeyStroke(null);
        this.mapId = decoder.nextToken();
        this.boardName = decoder.nextToken();
        this.x.setFormat(decoder.nextToken("0"));
        this.y.setFormat(decoder.nextToken("0"));
        this.backCommandName = decoder.nextToken("");
        this.backKey = decoder.nextKeyStroke(null);
        this.xIndex.setFormat(decoder.nextToken("0"));
        this.yIndex.setFormat(decoder.nextToken("0"));
        this.xOffset.setFormat(decoder.nextToken("0"));
        this.yOffset.setFormat(decoder.nextToken("0"));
        this.description = decoder.nextToken("");
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.commandName).append(this.key).append(this.mapId).append(this.boardName).append(this.x.getFormat()).append(this.y.getFormat()).append(this.backCommandName).append(this.backKey).append(this.xIndex.getFormat()).append(this.yIndex.getFormat()).append(this.xOffset.getFormat()).append(this.yOffset.getFormat()).append(this.description);
        return ID + sequenceEncoder.getValue();
    }

    protected KeyCommand[] myGetKeyCommands() {
        if (this.command == null) {
            this.sendCommand = new KeyCommand(this.commandName, this.key, Decorator.getOutermost(this));
            this.backCommand = new KeyCommand(this.backCommandName, this.backKey, Decorator.getOutermost(this));
            ArrayList<KeyCommand> arrayList = new ArrayList<KeyCommand>();
            if (this.commandName.length() > 0 && this.key != null) {
                arrayList.add(this.sendCommand);
            }
            if (this.backCommandName.length() > 0 && this.backKey != null) {
                arrayList.add(this.backCommand);
            }
            this.command = arrayList.toArray(new KeyCommand[arrayList.size()]);
        }
        for (int i = 0; i < this.command.length; ++i) {
            if (this.command[i].getName().equals(this.backCommandName)) {
                this.command[i].setEnabled(this.getMap() != null && this.getProperty(BACK_MAP) != null && this.getProperty(BACK_POINT) != null);
                continue;
            }
            this.command[i].setEnabled(this.getMap() != null);
        }
        return this.command;
    }

    public String myGetState() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        Map map = (Map)this.getProperty(BACK_MAP);
        if (map != null) {
            sequenceEncoder.append(map.getIdentifier());
        } else {
            sequenceEncoder.append("");
        }
        Point point = (Point)this.getProperty(BACK_POINT);
        if (point != null) {
            sequenceEncoder.append(point.x).append(point.y);
        } else {
            sequenceEncoder.append("").append("");
        }
        return sequenceEncoder.getValue();
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        Command command = null;
        this.myGetKeyCommands();
        if (this.sendCommand.matches(keyStroke)) {
            GamePiece gamePiece = Decorator.getOutermost(this);
            Stack stack = gamePiece.getParent();
            Map map = Map.getMapById(this.mapId);
            if (map == null) {
                map = this.getMap();
            }
            if (map != null) {
                Point point;
                try {
                    point = this.getDestination();
                }
                catch (Exception exception) {
                    return null;
                }
                Board board = map.getBoardByName(this.boardName);
                if (board != null) {
                    point.translate(board.bounds().x, board.bounds().y);
                }
                this.setProperty(BACK_MAP, this.getMap());
                this.setProperty(BACK_POINT, this.getPosition());
                if (!Boolean.TRUE.equals(gamePiece.getProperty("IgnoreGrid"))) {
                    point = map.snapTo(point);
                }
                command = map.placeOrMerge(gamePiece, point);
                if (map.getMoveKey() != null) {
                    command.append(gamePiece.keyEvent(map.getMoveKey()));
                }
                if (stack != null) {
                    command.append(stack.pieceRemoved(gamePiece));
                }
            }
        } else if (this.backCommand.matches(keyStroke)) {
            GamePiece gamePiece = Decorator.getOutermost(this);
            Map map = (Map)this.getProperty(BACK_MAP);
            Point point = (Point)this.getProperty(BACK_POINT);
            if (map != null && point != null) {
                command = map.placeOrMerge(gamePiece, point);
                if (map.getMoveKey() != null) {
                    command.append(gamePiece.keyEvent(map.getMoveKey()));
                }
            }
            this.setProperty(BACK_MAP, null);
            this.setProperty(BACK_POINT, null);
        }
        return command;
    }

    protected Point getDestination() {
        GamePiece gamePiece = Decorator.getOutermost(this);
        int n = Integer.parseInt(this.x.getText(gamePiece)) + Integer.parseInt(this.xIndex.getText(gamePiece)) * Integer.parseInt(this.xOffset.getText(gamePiece));
        int n2 = Integer.parseInt(this.y.getText(gamePiece)) + Integer.parseInt(this.yIndex.getText(gamePiece)) * Integer.parseInt(this.yOffset.getText(gamePiece));
        return new Point(n, n2);
    }

    public void mySetState(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        String string2 = decoder.nextToken("");
        if (string2.length() > 0) {
            this.setProperty(BACK_MAP, Map.getMapById(string2));
        }
        String string3 = decoder.nextToken("");
        String string4 = decoder.nextToken("");
        if (string3.length() > 0 && string4.length() > 0) {
            try {
                this.setProperty(BACK_POINT, new Point(Integer.parseInt(string3), Integer.parseInt(string4)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.piece.draw(graphics, n, n2, component, d);
    }

    public String getName() {
        return this.piece.getName();
    }

    public Shape getShape() {
        return this.piece.getShape();
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    public String getDescription() {
        String string = "Send to Location";
        if (this.description.length() > 0) {
            string = string + " - " + this.description;
        }
        return string;
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("SendToLocation.htm");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Ed
    implements PieceEditor {
        private StringConfigurer nameInput;
        private StringConfigurer backNameInput;
        private HotKeyConfigurer keyInput;
        private HotKeyConfigurer backKeyInput;
        private JTextField mapIdInput;
        private JTextField boardNameInput;
        private StringConfigurer xInput;
        private StringConfigurer yInput;
        protected BooleanConfigurer advancedInput;
        protected StringConfigurer xIndexInput;
        protected StringConfigurer xOffsetInput;
        protected StringConfigurer yIndexInput;
        protected StringConfigurer yOffsetInput;
        protected StringConfigurer descInput;
        private Map map;
        private JPanel controls = new JPanel();

        public Ed(SendToLocation sendToLocation) {
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            this.descInput = new StringConfigurer(null, "Description:  ", sendToLocation.description);
            this.controls.add(this.descInput.getControls());
            this.nameInput = new StringConfigurer(null, "Command name:  ", sendToLocation.commandName);
            this.controls.add(this.nameInput.getControls());
            this.keyInput = new HotKeyConfigurer(null, "Keyboard Command:  ", sendToLocation.key);
            this.controls.add(this.keyInput.getControls());
            this.backNameInput = new StringConfigurer(null, "Send Back Command name:  ", sendToLocation.backCommandName);
            this.controls.add(this.backNameInput.getControls());
            this.backKeyInput = new HotKeyConfigurer(null, "Send Back Keyboard Command:  ", sendToLocation.backKey);
            this.controls.add(this.backKeyInput.getControls());
            Box box = Box.createHorizontalBox();
            this.mapIdInput = new JTextField(12);
            this.map = Map.getMapById(sendToLocation.mapId);
            if (this.map != null) {
                this.mapIdInput.setText(this.map.getMapName());
            }
            this.mapIdInput.setEditable(false);
            box.add(new JLabel("Map:  "));
            box.add(this.mapIdInput);
            JButton jButton = new JButton("Select");
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ Ed this$0;
                {
                    this.this$0 = ed;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Ed.access$000(this.this$0);
                }
            });
            box.add(jButton);
            JButton jButton2 = new JButton("Clear");
            jButton2.addActionListener(new ActionListener(this){
                private final /* synthetic */ Ed this$0;
                {
                    this.this$0 = ed;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Ed.access$100(this.this$0);
                }
            });
            box.add(jButton2);
            this.controls.add(box);
            box = Box.createHorizontalBox();
            this.boardNameInput = new JTextField(12);
            this.boardNameInput.setText(sendToLocation.boardName);
            this.boardNameInput.setEditable(false);
            box.add(new JLabel("Board:  "));
            box.add(this.boardNameInput);
            jButton = new JButton("Select");
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ Ed this$0;
                {
                    this.this$0 = ed;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Ed.access$200(this.this$0);
                }
            });
            jButton2 = new JButton("Clear");
            jButton2.addActionListener(new ActionListener(this){
                private final /* synthetic */ Ed this$0;
                {
                    this.this$0 = ed;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Ed.access$300(this.this$0);
                }
            });
            box.add(jButton);
            box.add(jButton2);
            this.controls.add(box);
            this.xInput = new StringConfigurer(null, "X Position:  ", sendToLocation.x.getFormat());
            this.controls.add(this.xInput.getControls());
            this.yInput = new StringConfigurer(null, "Y Position:  ", sendToLocation.y.getFormat());
            this.controls.add(this.yInput.getControls());
            this.advancedInput = new BooleanConfigurer(null, "Advanced Options", false);
            this.advancedInput.addPropertyChangeListener(new PropertyChangeListener(this){
                private final /* synthetic */ Ed this$0;
                {
                    this.this$0 = ed;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Ed.access$400(this.this$0);
                }
            });
            this.controls.add(this.advancedInput.getControls());
            box = Box.createHorizontalBox();
            this.xIndexInput = new StringConfigurer(null, "Additional X offset:  ", sendToLocation.xIndex.getFormat());
            box.add(this.xIndexInput.getControls());
            this.xOffsetInput = new StringConfigurer(null, " times ", sendToLocation.xOffset.getFormat());
            box.add(this.xOffsetInput.getControls());
            this.controls.add(box);
            box = Box.createHorizontalBox();
            this.yIndexInput = new StringConfigurer(null, "Additional Y offset:  ", sendToLocation.yIndex.getFormat());
            box.add(this.yIndexInput.getControls());
            this.yOffsetInput = new StringConfigurer(null, " times ", sendToLocation.yOffset.getFormat());
            box.add(this.yOffsetInput.getControls());
            this.controls.add(box);
            this.updateAdvancedVisibility();
        }

        private void updateAdvancedVisibility() {
            boolean bl = this.advancedInput.booleanValue();
            this.xIndexInput.getControls().setVisible(bl);
            this.xOffsetInput.getControls().setVisible(bl);
            this.yIndexInput.getControls().setVisible(bl);
            this.yOffsetInput.getControls().setVisible(bl);
            Window window = SwingUtilities.getWindowAncestor(this.controls);
            if (window != null) {
                window.pack();
            }
        }

        private void clearBoard() {
            this.boardNameInput.setText("");
        }

        private void clearMap() {
            this.map = null;
            this.mapIdInput.setText("");
        }

        private void selectBoard() {
            ChooseComponentDialog chooseComponentDialog = new ChooseComponentDialog((Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = SendToLocation.class$("java.awt.Frame")) : class$java$awt$Frame, this.controls), class$VASSAL$build$module$map$boardPicker$Board == null ? (class$VASSAL$build$module$map$boardPicker$Board = SendToLocation.class$("VASSAL.build.module.map.boardPicker.Board")) : class$VASSAL$build$module$map$boardPicker$Board);
            ((Component)chooseComponentDialog).setVisible(true);
            if (chooseComponentDialog.getTarget() != null) {
                Board board = (Board)chooseComponentDialog.getTarget();
                this.boardNameInput.setText(board.getName());
            }
        }

        private void selectMap() {
            ChooseComponentDialog chooseComponentDialog = new ChooseComponentDialog((Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = SendToLocation.class$("java.awt.Frame")) : class$java$awt$Frame, this.controls), class$VASSAL$build$module$Map == null ? (class$VASSAL$build$module$Map = SendToLocation.class$("VASSAL.build.module.Map")) : class$VASSAL$build$module$Map);
            ((Component)chooseComponentDialog).setVisible(true);
            if (chooseComponentDialog.getTarget() != null) {
                this.map = (Map)chooseComponentDialog.getTarget();
                this.mapIdInput.setText(this.map.getMapName());
            }
        }

        public Component getControls() {
            return this.controls;
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(this.nameInput.getValueString()).append((KeyStroke)this.keyInput.getValue()).append(this.map == null ? "" : this.map.getIdentifier()).append(this.boardNameInput.getText()).append(this.xInput.getValueString()).append(this.yInput.getValueString()).append(this.backNameInput.getValueString()).append((KeyStroke)this.backKeyInput.getValue()).append(this.xIndexInput.getValueString()).append(this.yIndexInput.getValueString()).append(this.xOffsetInput.getValueString()).append(this.yOffsetInput.getValueString()).append(this.descInput.getValueString());
            return SendToLocation.ID + sequenceEncoder.getValue();
        }

        public String getState() {
            return "";
        }

        static /* synthetic */ void access$000(Ed ed) {
            ed.selectMap();
        }

        static /* synthetic */ void access$100(Ed ed) {
            ed.clearMap();
        }

        static /* synthetic */ void access$200(Ed ed) {
            ed.selectBoard();
        }

        static /* synthetic */ void access$300(Ed ed) {
            ed.clearBoard();
        }

        static /* synthetic */ void access$400(Ed ed) {
            ed.updateAdvancedVisibility();
        }
    }
}

