/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.map.StackMetrics;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.Command;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.PieceIterator;
import VASSAL.counters.StateMergeable;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.KeyStroke;

public class Stack
implements GamePiece,
StateMergeable {
    public static final String TYPE = "stack";
    protected static final int INCR = 5;
    protected GamePiece[] contents = new GamePiece[5];
    protected int pieceCount = 0;
    protected Point pos = new Point(0, 0);
    private String id;
    private boolean expanded = false;
    protected Map map;
    private static StackMetrics defaultMetrics;

    public Stack() {
        this(null);
    }

    public Stack(GamePiece gamePiece) {
        if (gamePiece != null) {
            this.setMap(gamePiece.getMap());
            this.setPosition(new Point(gamePiece.getPosition()));
            this.add(gamePiece);
        }
    }

    public Enumeration getPieces() {
        return new AllPieceEnum();
    }

    public Enumeration getPiecesInReverseOrder() {
        return new ReversePieceEnum();
    }

    public Enumeration getPiecesInVisibleOrder() {
        return new VisibleOrderEnum();
    }

    public void remove(GamePiece gamePiece) {
        this.removePieceAt(this.indexOf(gamePiece));
        if (this.getMap() != null) {
            this.getMap().repaint();
        }
    }

    protected void removePieceAt(int n) {
        if (n >= 0 && n < this.pieceCount) {
            --this.pieceCount;
            for (int i = n; i < this.pieceCount; ++i) {
                this.contents[i] = this.contents[i + 1];
            }
            this.expanded = this.expanded && this.pieceCount > 1;
        }
    }

    public Command pieceRemoved(GamePiece gamePiece) {
        return null;
    }

    protected void insertPieceAt(GamePiece gamePiece, int n) {
        if (this.pieceCount >= this.contents.length) {
            GamePiece[] gamePieceArray = new GamePiece[this.contents.length + 5];
            System.arraycopy(this.contents, 0, gamePieceArray, 0, this.pieceCount);
            this.contents = gamePieceArray;
        }
        for (int i = this.pieceCount; i > n; --i) {
            this.contents[i] = this.contents[i - 1];
        }
        this.contents[n] = gamePiece;
        ++this.pieceCount;
    }

    public void removeAll() {
        this.pieceCount = 0;
        this.expanded = false;
    }

    public int indexOf(GamePiece gamePiece) {
        int n = -1;
        for (int i = 0; i < this.pieceCount; ++i) {
            if (gamePiece != this.contents[i]) continue;
            n = i;
            break;
        }
        return n;
    }

    public GamePiece getPieceAt(int n) {
        return this.contents[n];
    }

    public void add(GamePiece gamePiece) {
        this.insert(gamePiece, this.pieceCount);
    }

    public void insertChild(GamePiece gamePiece, int n) {
        if (gamePiece.getParent() != null) {
            gamePiece.getParent().remove(gamePiece);
        } else if (gamePiece.getMap() != null) {
            gamePiece.getMap().removePiece(gamePiece);
        }
        gamePiece.setParent(this);
        this.insertPieceAt(gamePiece, n);
    }

    public int getPieceCount() {
        return this.pieceCount;
    }

    public void insert(GamePiece gamePiece, int n) {
        if (gamePiece == null) {
            return;
        }
        n = Math.max(n, 0);
        n = Math.min(n, this.pieceCount);
        int n2 = this.indexOf(gamePiece);
        if (n2 >= 0) {
            if (n > n2) {
                this.insertPieceAt(gamePiece, n + 1);
                this.removePieceAt(n2);
            } else {
                this.removePieceAt(n2);
                this.insertPieceAt(gamePiece, n);
            }
        } else {
            this.insertChild(gamePiece, n);
        }
    }

    public Command pieceAdded(GamePiece gamePiece) {
        return null;
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        if (component instanceof Map.View) {
            ((Map.View)component).getMap().getStackMetrics().draw(this, graphics, n, n2, component, d);
        } else {
            this.getDefaultMetrics().draw(this, graphics, n, n2, component, d);
        }
    }

    public String getName() {
        String string = "";
        PieceIterator pieceIterator = PieceIterator.visible(this.getPiecesInReverseOrder());
        while (pieceIterator.hasMoreElements()) {
            GamePiece gamePiece = pieceIterator.nextPiece();
            String string2 = gamePiece.getName();
            string = string + string2;
            if (string2.length() <= 0 || !pieceIterator.hasMoreElements()) continue;
            string = string + ", ";
        }
        return string;
    }

    public Rectangle boundingBox() {
        Rectangle rectangle = new Rectangle();
        Rectangle[] rectangleArray = new Rectangle[this.getPieceCount()];
        this.getMap().getStackMetrics().getContents(this, null, null, rectangleArray, 0, 0);
        PieceIterator pieceIterator = PieceIterator.visible(this.getPieces());
        while (pieceIterator.hasMoreElements()) {
            GamePiece gamePiece = pieceIterator.nextPiece();
            rectangle = rectangle.union(rectangleArray[this.indexOf(gamePiece)]);
        }
        return rectangle;
    }

    public Shape getShape() {
        Area area = new Area();
        Shape[] shapeArray = new Shape[this.getPieceCount()];
        this.getMap().getStackMetrics().getContents(this, null, shapeArray, null, 0, 0);
        PieceIterator pieceIterator = PieceIterator.visible(this.getPieces());
        while (pieceIterator.hasMoreElements()) {
            GamePiece gamePiece = pieceIterator.nextPiece();
            area.add(new Area(shapeArray[this.indexOf(gamePiece)]));
        }
        return area;
    }

    public void selectNext(GamePiece gamePiece) {
        KeyBuffer.getBuffer().remove(gamePiece);
        if (this.pieceCount > 1 && this.indexOf(gamePiece) >= 0) {
            int n = this.indexOf(gamePiece) == this.pieceCount - 1 ? this.pieceCount - 2 : this.indexOf(gamePiece) + 1;
            for (int i = 0; i < this.pieceCount; ++i) {
                if (this.indexOf(this.contents[i]) != n) continue;
                KeyBuffer.getBuffer().add(this.contents[i]);
                return;
            }
        }
    }

    public GamePiece getPieceBeneath(GamePiece gamePiece) {
        int n = this.indexOf(gamePiece);
        while (n-- > 0) {
            if (Boolean.TRUE.equals(this.contents[n].getProperty("Invisible"))) continue;
            return this.contents[n];
        }
        return null;
    }

    public GamePiece getPieceAbove(GamePiece gamePiece) {
        int n = this.indexOf(gamePiece);
        while (++n < this.getPieceCount()) {
            if (Boolean.TRUE.equals(this.contents[n].getProperty("Invisible"))) continue;
            return this.contents[n];
        }
        return null;
    }

    public GamePiece topPiece() {
        for (int i = this.pieceCount - 1; i >= 0; --i) {
            if (Boolean.TRUE.equals(this.contents[i].getProperty("Invisible"))) continue;
            return this.contents[i];
        }
        return null;
    }

    public GamePiece topPiece(String string) {
        for (int i = this.pieceCount - 1; i >= 0; --i) {
            String string2 = (String)this.contents[i].getProperty("hiddenBy");
            if (string2 != null && !string2.equals(string)) continue;
            return this.contents[i];
        }
        return null;
    }

    public GamePiece bottomPiece(String string) {
        for (int i = 0; i < this.pieceCount; ++i) {
            String string2 = (String)this.contents[i].getProperty("hiddenBy");
            if (string2 != null && !string2.equals(string)) continue;
            return this.contents[i];
        }
        return null;
    }

    public GamePiece bottomPiece() {
        for (int i = 0; i < this.pieceCount; ++i) {
            if (Boolean.TRUE.equals(this.contents[i].getProperty("Invisible"))) continue;
            return this.contents[i];
        }
        return null;
    }

    protected int nVisible() {
        int n = 0;
        PieceIterator pieceIterator = PieceIterator.visible(this.getPieces());
        while (pieceIterator.hasMoreElements()) {
            pieceIterator.nextPiece();
            ++n;
        }
        return n;
    }

    public Command keyEvent(KeyStroke keyStroke) {
        GamePiece gamePiece = this.topPiece();
        if (gamePiece != null) {
            return gamePiece.keyEvent(keyStroke);
        }
        return null;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean bl) {
        this.expanded = bl;
    }

    public String getState() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.getMap() == null ? "null" : this.getMap().getIdentifier()).append(this.getPosition().x).append(this.getPosition().y);
        for (int i = 0; i < this.pieceCount; ++i) {
            sequenceEncoder.append(this.contents[i].getId());
        }
        return sequenceEncoder.getValue();
    }

    public void setState(String string) {
        PropertySource propertySource;
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        String string2 = decoder.nextToken();
        this.setPosition(new Point(decoder.nextInt(0), decoder.nextInt(0)));
        this.pieceCount = 0;
        while (decoder.hasMoreTokens()) {
            propertySource = GameModule.getGameModule().getGameState().getPieceForId(decoder.nextToken());
            if (propertySource == null) continue;
            this.insertChild((GamePiece)propertySource, this.pieceCount);
        }
        propertySource = null;
        if (!"null".equals(string2) && (propertySource = Map.getMapById(string2)) == null) {
            throw new RuntimeException("Could not find map " + string2);
        }
        if (propertySource != this.getMap()) {
            if (propertySource != null) {
                ((Map)propertySource).addPiece(this);
            } else {
                this.setMap(null);
            }
        }
    }

    public void mergeState(String string, String string2) {
        String string3 = string;
        if (!string2.equals(this.getState())) {
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
            SequenceEncoder.Decoder decoder2 = new SequenceEncoder.Decoder(string2, ';');
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(decoder.nextToken());
            decoder2.nextToken();
            sequenceEncoder.append(decoder.nextToken());
            decoder2.nextToken();
            sequenceEncoder.append(decoder.nextToken());
            decoder2.nextToken();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (decoder.hasMoreTokens()) {
                arrayList.add(decoder.nextToken());
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while (decoder2.hasMoreTokens()) {
                arrayList2.add(decoder2.nextToken());
            }
            int n = this.getPieceCount();
            for (int i = 0; i < n; ++i) {
                String string4 = this.getPieceAt(i).getId();
                if (arrayList.contains(string4) || arrayList2.contains(string4)) continue;
                int n2 = i == 0 ? -1 : arrayList.indexOf(this.getPieceAt(i - 1).getId());
                arrayList.add(n2 + 1, string4);
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                sequenceEncoder.append(iterator.next().toString());
            }
            string3 = sequenceEncoder.getValue();
        }
        this.setState(string3);
    }

    public String getType() {
        return TYPE;
    }

    public void setProperty(Object object, Object object2) {
    }

    public String toString() {
        return super.toString() + "[" + this.getName() + "]";
    }

    public void setPropertyOnContents(Object object, Object object2) {
        Enumeration enumeration = this.getPieces();
        while (enumeration.hasMoreElements()) {
            ((GamePiece)enumeration.nextElement()).setProperty(object, object2);
        }
    }

    public Object getProperty(Object object) {
        return null;
    }

    public void setMap(Map map) {
        this.map = map;
    }

    public Map getMap() {
        return this.map;
    }

    public Point getPosition() {
        return new Point(this.pos);
    }

    public void setPosition(Point point) {
        this.pos = point;
    }

    public Stack getParent() {
        return null;
    }

    public void setParent(Stack stack) {
        if (stack != null) {
            throw new RuntimeException("Cannot add Stack to parent");
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public static void setDefaultMetrics(StackMetrics stackMetrics) {
        defaultMetrics = stackMetrics;
    }

    public StackMetrics getDefaultMetrics() {
        if (defaultMetrics == null) {
            Stack.setDefaultMetrics(new StackMetrics());
        }
        return defaultMetrics;
    }

    private class ReversePieceEnum
    implements Enumeration {
        private int index;
        private GamePiece[] clone;

        public ReversePieceEnum() {
            this.clone = new GamePiece[Stack.this.pieceCount];
            System.arraycopy(Stack.this.contents, 0, this.clone, 0, Stack.this.pieceCount);
            this.index = Stack.this.pieceCount - 1;
        }

        public boolean hasMoreElements() {
            return this.index >= 0;
        }

        public Object nextElement() {
            return this.clone[this.index--];
        }
    }

    private class AllPieceEnum
    implements Enumeration {
        private int index = 0;
        private GamePiece[] p;

        public AllPieceEnum() {
            this.p = new GamePiece[Stack.this.pieceCount];
            System.arraycopy(Stack.this.contents, 0, this.p, 0, Stack.this.pieceCount);
        }

        public boolean hasMoreElements() {
            return this.index < this.p.length;
        }

        public Object nextElement() {
            return this.p[this.index++];
        }
    }

    private class VisibleOrderEnum
    implements Enumeration {
        private GamePiece next;
        private int index;
        private boolean doingSelected = true;

        public VisibleOrderEnum() {
            this.index = Stack.this.pieceCount - 1;
            this.next = this.findNext();
        }

        public boolean hasMoreElements() {
            return this.next != null;
        }

        public Object nextElement() {
            GamePiece gamePiece = this.next;
            this.next = this.findNext();
            return gamePiece;
        }

        private GamePiece findNext() {
            GamePiece gamePiece = null;
            while (this.index >= 0) {
                GamePiece gamePiece2;
                if (!(this.doingSelected ^ !Boolean.TRUE.equals((gamePiece2 = Stack.this.getPieceAt(this.index--)).getProperty("Selected")))) continue;
                gamePiece = gamePiece2;
                break;
            }
            if (gamePiece == null && this.doingSelected) {
                this.doingSelected = false;
                this.index = Stack.this.pieceCount - 1;
                gamePiece = this.findNext();
            }
            return gamePiece;
        }
    }
}

