/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.MovementReporter;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitor;
import VASSAL.counters.DeckVisitorDispatcher;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.FreeRotator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.Stack;
import VASSAL.tools.FormattedString;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class Translate
extends Decorator
implements EditablePiece {
    public static final String ID = "translate;";
    protected KeyCommand[] commands;
    protected String commandName;
    protected KeyStroke keyCommand;
    protected FormattedString xDist = new FormattedString("");
    protected FormattedString xIndex = new FormattedString("");
    protected FormattedString xOffset = new FormattedString("");
    protected FormattedString yDist = new FormattedString("");
    protected FormattedString yIndex = new FormattedString("");
    protected FormattedString yOffset = new FormattedString("");
    protected String description;
    protected boolean moveStack;
    protected KeyCommand moveCommand;
    protected static MoveExecuter mover;
    static /* synthetic */ Class class$VASSAL$counters$FreeRotator;

    public Translate() {
        this("translate;Move Forward", null);
    }

    public Translate(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    public String getDescription() {
        String string = "Move fixed distance";
        if (this.description.length() > 0) {
            string = string + " - " + this.description;
        }
        return string;
    }

    public void mySetType(String string) {
        string = string.substring(ID.length());
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        this.commandName = decoder.nextToken("Move Forward");
        this.keyCommand = decoder.nextKeyStroke('M');
        this.xDist.setFormat(decoder.nextToken("0"));
        this.yDist.setFormat(decoder.nextToken("60"));
        this.moveStack = decoder.nextBoolean(true);
        this.xIndex.setFormat(decoder.nextToken("0"));
        this.yIndex.setFormat(decoder.nextToken("0"));
        this.xOffset.setFormat(decoder.nextToken("0"));
        this.yOffset.setFormat(decoder.nextToken("0"));
        this.description = decoder.nextToken("");
        this.commands = null;
    }

    protected KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            this.moveCommand = new KeyCommand(this.commandName, this.keyCommand, Decorator.getOutermost(this));
            this.commands = this.commandName.length() > 0 ? new KeyCommand[]{this.moveCommand} : new KeyCommand[0];
        }
        this.moveCommand.setEnabled(this.getMap() != null);
        return this.commands;
    }

    public String myGetState() {
        return "";
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.commandName).append(this.keyCommand).append(this.xDist.getFormat()).append(this.yDist.getFormat()).append(this.moveStack).append(this.xIndex.getFormat()).append(this.yIndex.getFormat()).append(this.xOffset.getFormat()).append(this.yOffset.getFormat()).append(this.description);
        return ID + sequenceEncoder.getValue();
    }

    public Command keyEvent(KeyStroke keyStroke) {
        this.myGetKeyCommands();
        if (this.moveCommand.matches(keyStroke)) {
            return this.myKeyEvent(keyStroke);
        }
        return super.keyEvent(keyStroke);
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        this.myGetKeyCommands();
        Command command = null;
        if (this.moveCommand.matches(keyStroke)) {
            GamePiece gamePiece;
            if (mover == null) {
                mover = new MoveExecuter();
                mover.setKeyEvent(keyStroke);
                SwingUtilities.invokeLater(mover);
            }
            if ((gamePiece = this.findTarget(keyStroke)) != null) {
                command = this.moveTarget(gamePiece);
            }
            mover.addKeyEventTarget(this.piece);
            command = new NullCommand(){

                public boolean isNull() {
                    return false;
                }
            };
        }
        return command;
    }

    protected Command moveTarget(GamePiece gamePiece) {
        Point point = new Point(this.getPosition());
        this.translate(point);
        FreeRotator freeRotator = (FreeRotator)Decorator.getDecorator(this, class$VASSAL$counters$FreeRotator == null ? (class$VASSAL$counters$FreeRotator = Translate.class$("VASSAL.counters.FreeRotator")) : class$VASSAL$counters$FreeRotator);
        if (freeRotator != null) {
            Point point2 = this.getPosition().getLocation();
            Point2D point2D = point.getLocation();
            point2D = AffineTransform.getRotateInstance(freeRotator.getAngleInRadians(), ((Point2D)point2).getX(), ((Point2D)point2).getY()).transform(point2D, null);
            point = new Point((int)point2D.getX(), (int)point2D.getY());
        }
        if (!Boolean.TRUE.equals(Decorator.getOutermost(this).getProperty("IgnoreGrid"))) {
            point = this.getMap().snapTo(point);
        }
        mover.add(gamePiece.getMap(), gamePiece, point);
        return null;
    }

    protected void translate(Point point) {
        int n = 0;
        int n2 = 0;
        GamePiece gamePiece = Decorator.getOutermost(this);
        try {
            n = Integer.parseInt(this.xDist.getText(gamePiece)) + Integer.parseInt(this.xIndex.getText(gamePiece)) * Integer.parseInt(this.xOffset.getText(gamePiece));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            n2 = Integer.parseInt(this.yDist.getText(gamePiece)) + Integer.parseInt(this.yIndex.getText(gamePiece)) * Integer.parseInt(this.yOffset.getText(gamePiece));
        }
        catch (Exception exception) {
            // empty catch block
        }
        point.translate(n, -n2);
    }

    protected GamePiece findTarget(KeyStroke keyStroke) {
        GamePiece gamePiece;
        GamePiece gamePiece2 = gamePiece = Decorator.getOutermost(this);
        if (this.moveStack && gamePiece.getParent() != null && !gamePiece.getParent().isExpanded()) {
            gamePiece2 = gamePiece != gamePiece.getParent().topPiece(GameModule.getUserId()) ? null : gamePiece.getParent();
        }
        return gamePiece2;
    }

    public void mySetState(String string) {
    }

    public Rectangle boundingBox() {
        return this.getInner().boundingBox();
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.getInner().draw(graphics, n, n2, component, d);
    }

    public String getName() {
        return this.getInner().getName();
    }

    public Shape getShape() {
        return this.getInner().getShape();
    }

    public PieceEditor getEditor() {
        return new Editor(this);
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Translate.htm");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class MoveExecuter
    implements Runnable {
        private List moves = new ArrayList();
        private Set pieces = new HashSet();
        private KeyStroke stroke;
        private List innerPieces = new ArrayList();

        public void run() {
            Object object;
            Object object2;
            Object object3;
            mover = null;
            NullCommand nullCommand = new NullCommand();
            Object object4 = this.moves.iterator();
            while (object4.hasNext()) {
                object3 = (Move)object4.next();
                object2 = new Map.Merger(((Move)object3).map, ((Move)object3).pos, ((Move)object3).piece);
                object = new DeckVisitor(this, (Map.Merger)object2, (Move)object3){
                    private final /* synthetic */ Map.Merger val$merger;
                    private final /* synthetic */ Move val$move;
                    private final /* synthetic */ MoveExecuter this$0;
                    {
                        this.this$0 = moveExecuter;
                        this.val$merger = merger;
                        this.val$move = move;
                    }

                    public Object visitDeck(Deck deck) {
                        return this.val$merger.visitDeck(deck);
                    }

                    public Object visitStack(Stack stack) {
                        if (!MoveExecuter.access$400(this.this$0).contains(stack) && Move.access$100(this.val$move).getPieceCollection().canMerge(stack, Move.access$300(this.val$move))) {
                            return this.val$merger.visitStack(stack);
                        }
                        return null;
                    }

                    public Object visitDefault(GamePiece gamePiece) {
                        if (!MoveExecuter.access$400(this.this$0).contains(gamePiece) && Move.access$100(this.val$move).getPieceCollection().canMerge(gamePiece, Move.access$300(this.val$move))) {
                            return this.val$merger.visitDefault(gamePiece);
                        }
                        return null;
                    }
                };
                DeckVisitorDispatcher deckVisitorDispatcher = new DeckVisitorDispatcher((DeckVisitor)object);
                Command command = ((Move)object3).map.apply(deckVisitorDispatcher);
                if (command == null) {
                    command = ((Move)object3).map.placeAt(((Move)object3).piece, ((Move)object3).pos);
                    if (((Move)object3).map.getMoveKey() != null) {
                        command.append(Decorator.getOutermost(((Move)object3).piece).keyEvent(((Move)object3).map.getMoveKey()));
                    }
                }
                nullCommand.append(command);
                ((Move)object3).map.ensureVisible(((Move)object3).map.selectionBoundsOf(((Move)object3).piece));
                this.pieces.remove(((Move)object3).piece);
                ((Move)object3).map.repaint();
            }
            object4 = new MovementReporter(nullCommand);
            object3 = ((MovementReporter)object4).getReportCommand();
            if (object3 != null) {
                ((Command)object3).execute();
            }
            nullCommand.append((Command)object3);
            nullCommand.append(((MovementReporter)object4).markMovedPieces());
            if (this.stroke != null) {
                object2 = this.innerPieces.iterator();
                while (object2.hasNext()) {
                    object = (GamePiece)object2.next();
                    nullCommand.append(object.keyEvent(this.stroke));
                }
            }
            GameModule.getGameModule().sendAndLog(nullCommand);
        }

        public void add(Map map, GamePiece gamePiece, Point point) {
            this.moves.add(new Move(map, gamePiece, point));
            this.pieces.add(gamePiece);
        }

        public void addKeyEventTarget(GamePiece gamePiece) {
            this.innerPieces.add(gamePiece);
        }

        public void setKeyEvent(KeyStroke keyStroke) {
            this.stroke = keyStroke;
        }

        static /* synthetic */ Set access$400(MoveExecuter moveExecuter) {
            return moveExecuter.pieces;
        }

        private static class Move {
            private Map map;
            private GamePiece piece;
            private Point pos;

            public Move(Map map, GamePiece gamePiece, Point point) {
                this.map = map;
                this.piece = gamePiece;
                this.pos = point;
            }
        }
    }

    public static class Editor
    implements PieceEditor {
        private StringConfigurer xDist;
        private StringConfigurer yDist;
        private StringConfigurer name;
        private HotKeyConfigurer key;
        private JPanel controls = new JPanel();
        private BooleanConfigurer moveStack;
        protected BooleanConfigurer advancedInput;
        protected StringConfigurer xIndexInput;
        protected StringConfigurer xOffsetInput;
        protected StringConfigurer yIndexInput;
        protected StringConfigurer yOffsetInput;
        protected StringConfigurer descInput;

        public Editor(Translate translate) {
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            this.descInput = new StringConfigurer(null, "Description:  ", translate.description);
            this.controls.add(this.descInput.getControls());
            this.name = new StringConfigurer(null, "Command Name:  ", translate.commandName);
            this.controls.add(this.name.getControls());
            this.key = new HotKeyConfigurer(null, "Keyboard shortcut:  ", translate.keyCommand);
            this.controls.add(this.key.getControls());
            this.xDist = new StringConfigurer(null, "Distance to the right:  ", translate.xDist.getFormat());
            this.controls.add(this.xDist.getControls());
            this.yDist = new StringConfigurer(null, "Distance upwards:  ", translate.yDist.getFormat());
            this.controls.add(this.yDist.getControls());
            this.moveStack = new BooleanConfigurer(null, "Move entire stack", new Boolean(translate.moveStack));
            this.controls.add(this.moveStack.getControls());
            this.advancedInput = new BooleanConfigurer(null, "Advanced Options", false);
            this.advancedInput.addPropertyChangeListener(new PropertyChangeListener(this){
                private final /* synthetic */ Editor this$0;
                {
                    this.this$0 = editor;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Editor.access$000(this.this$0);
                }
            });
            this.controls.add(this.advancedInput.getControls());
            Box box = Box.createHorizontalBox();
            this.xIndexInput = new StringConfigurer(null, "Additional offset to the right:  ", translate.xIndex.getFormat());
            box.add(this.xIndexInput.getControls());
            this.xOffsetInput = new StringConfigurer(null, " times ", translate.xOffset.getFormat());
            box.add(this.xOffsetInput.getControls());
            this.controls.add(box);
            box = Box.createHorizontalBox();
            this.yIndexInput = new StringConfigurer(null, "Additional offset upwards:  ", translate.yIndex.getFormat());
            box.add(this.yIndexInput.getControls());
            this.yOffsetInput = new StringConfigurer(null, " times ", translate.yOffset.getFormat());
            box.add(this.yOffsetInput.getControls());
            this.controls.add(box);
            this.updateAdvancedVisibility();
        }

        private void updateAdvancedVisibility() {
            boolean bl = this.advancedInput.booleanValue();
            this.xIndexInput.getControls().setVisible(bl);
            this.xOffsetInput.getControls().setVisible(bl);
            this.yIndexInput.getControls().setVisible(bl);
            this.yOffsetInput.getControls().setVisible(bl);
            Window window = SwingUtilities.getWindowAncestor(this.controls);
            if (window != null) {
                window.pack();
            }
        }

        public Component getControls() {
            return this.controls;
        }

        public String getState() {
            return "";
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(this.name.getValueString()).append((KeyStroke)this.key.getValue()).append(this.xDist.getValueString()).append(this.yDist.getValueString()).append(this.moveStack.getValueString()).append(this.xIndexInput.getValueString()).append(this.yIndexInput.getValueString()).append(this.xOffsetInput.getValueString()).append(this.yOffsetInput.getValueString()).append(this.descInput.getValueString());
            return Translate.ID + sequenceEncoder.getValue();
        }

        static /* synthetic */ void access$000(Editor editor) {
            editor.updateAdvancedVisibility();
        }
    }
}

