/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.KeyStrokeArrayConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.PieceFilter;
import VASSAL.counters.PropertiesPieceFilter;
import VASSAL.tools.FormattedString;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class TriggerAction
extends Decorator
implements EditablePiece {
    public static final String ID = "macro;";
    protected String name = "";
    protected String command = "";
    protected KeyStroke key = null;
    protected String propertyMatch = "";
    protected KeyStroke[] watchKeys = new KeyStroke[0];
    protected KeyStroke[] actionKeys = new KeyStroke[0];
    protected Set triggeredKeys;

    public TriggerAction() {
        this(ID, null);
    }

    public TriggerAction(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.piece.draw(graphics, n, n2, component, d);
    }

    public String getName() {
        return this.piece.getName();
    }

    protected KeyCommand[] myGetKeyCommands() {
        if (this.command.length() > 0 && this.key != null) {
            return new KeyCommand[]{new KeyCommand(this.command, this.key, Decorator.getOutermost(this), this.matchesFilter())};
        }
        return new KeyCommand[0];
    }

    public String myGetState() {
        return "";
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.name).append(this.command).append(this.key).append(this.propertyMatch).append(KeyStrokeArrayConfigurer.encode(this.watchKeys)).append(KeyStrokeArrayConfigurer.encode(this.actionKeys));
        return ID + sequenceEncoder.getValue();
    }

    public Command keyEvent(KeyStroke keyStroke) {
        Command command = this.piece.keyEvent(keyStroke);
        return command == null ? this.myKeyEvent(keyStroke) : command.append(this.myKeyEvent(keyStroke));
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        if (this.triggeredKeys == null) {
            this.triggeredKeys = new HashSet();
            Runnable runnable = new Runnable(){

                public void run() {
                    TriggerAction.this.triggeredKeys = null;
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
        boolean bl = false;
        if (keyStroke.equals(this.key) && !this.triggeredKeys.contains(this.key)) {
            bl = true;
            this.triggeredKeys.add(this.key);
        }
        for (int i = 0; i < this.watchKeys.length && !bl; ++i) {
            if (!keyStroke.equals(this.watchKeys[i]) || this.triggeredKeys.contains(this.watchKeys[i])) continue;
            bl = true;
            this.triggeredKeys.add(this.watchKeys[i]);
        }
        if (!bl) {
            return null;
        }
        if (!this.matchesFilter()) {
            return null;
        }
        GamePiece gamePiece = Decorator.getOutermost(this);
        NullCommand nullCommand = new NullCommand();
        for (int i = 0; i < this.actionKeys.length; ++i) {
            nullCommand.append(gamePiece.keyEvent(this.actionKeys[i]));
        }
        return nullCommand;
    }

    protected boolean matchesFilter() {
        PieceFilter pieceFilter;
        GamePiece gamePiece = Decorator.getOutermost(this);
        return this.propertyMatch == null || this.propertyMatch.length() <= 0 || (pieceFilter = PropertiesPieceFilter.parse(new FormattedString(this.propertyMatch).getText(gamePiece))).accept(gamePiece);
    }

    public void mySetState(String string) {
    }

    public Shape getShape() {
        return this.piece.getShape();
    }

    public String getDescription() {
        String string = "Trigger Action";
        if (this.name.length() > 0) {
            string = string + " - " + this.name;
        }
        return string;
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("TriggerAction.htm");
    }

    public void mySetType(String string) {
        int n;
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        decoder.nextToken();
        this.name = decoder.nextToken("");
        this.command = decoder.nextToken("Trigger");
        this.key = decoder.nextKeyStroke('T');
        this.propertyMatch = decoder.nextToken("");
        String string2 = decoder.nextToken("");
        if (string2.indexOf(44) > 0) {
            this.watchKeys = KeyStrokeArrayConfigurer.decode(string2);
        } else {
            this.watchKeys = new KeyStroke[string2.length()];
            for (n = 0; n < this.watchKeys.length; ++n) {
                this.watchKeys[n] = KeyStroke.getKeyStroke((int)string2.charAt(n), 2);
            }
        }
        string2 = decoder.nextToken("");
        if (string2.indexOf(44) > 0) {
            this.actionKeys = KeyStrokeArrayConfigurer.decode(string2);
        } else {
            this.actionKeys = new KeyStroke[string2.length()];
            for (n = 0; n < this.actionKeys.length; ++n) {
                this.actionKeys[n] = KeyStroke.getKeyStroke((int)string2.charAt(n), 2);
            }
        }
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    public static class Ed
    implements PieceEditor {
        private StringConfigurer name;
        private StringConfigurer command;
        private HotKeyConfigurer key;
        private StringConfigurer propertyMatch;
        private KeyStrokeArrayConfigurer watchKeys;
        private KeyStrokeArrayConfigurer actionKeys;
        private JPanel box = new JPanel();

        public Ed(TriggerAction triggerAction) {
            this.box.setLayout(new BoxLayout(this.box, 1));
            this.name = new StringConfigurer(null, "Description:  ", triggerAction.name);
            this.box.add(this.name.getControls());
            this.propertyMatch = new StringConfigurer(null, "Trigger when properties match:  ", triggerAction.propertyMatch);
            this.box.add(this.propertyMatch.getControls());
            Box box = Box.createHorizontalBox();
            this.command = new StringConfigurer(null, "Menu Command:  ", triggerAction.command);
            box.add(this.command.getControls());
            this.key = new HotKeyConfigurer(null, "  KeyStroke:  ", triggerAction.key);
            box.add(this.key.getControls());
            this.box.add(box);
            this.watchKeys = new KeyStrokeArrayConfigurer(null, "Watch for these Keystrokes:  ", triggerAction.watchKeys);
            this.box.add(this.watchKeys.getControls());
            this.actionKeys = new KeyStrokeArrayConfigurer(null, "Perform these Keystrokes:  ", triggerAction.actionKeys);
            this.box.add(this.actionKeys.getControls());
        }

        public Component getControls() {
            return this.box;
        }

        public String getState() {
            return "";
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(this.name.getValueString()).append(this.command.getValueString()).append((KeyStroke)this.key.getValue()).append(this.propertyMatch.getValueString()).append(this.watchKeys.getValueString()).append(this.actionKeys.getValueString());
            return TriggerAction.ID + sequenceEncoder.getValue();
        }
    }
}

