/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.GameModule;
import VASSAL.build.module.BasicLogger;
import VASSAL.build.module.GameState;
import VASSAL.build.module.GlobalOptions;
import VASSAL.chat.ChatServerFactory;
import VASSAL.chat.DynamicClient;
import VASSAL.chat.node.NodeClientFactory;
import VASSAL.chat.ui.ChatServerControls;
import VASSAL.command.Command;
import VASSAL.preferences.PositionOption;
import VASSAL.preferences.Prefs;
import VASSAL.tools.DataArchive;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import org.w3c.dom.Element;

public class BasicModule
extends GameModule {
    private static char COMMAND_SEPARATOR = (char)27;
    static /* synthetic */ Class class$VASSAL$build$module$gamepieceimage$GamePieceImageDefinitions;
    static /* synthetic */ Class class$VASSAL$build$module$properties$GlobalProperties;
    static /* synthetic */ Class class$VASSAL$build$module$BasicCommandEncoder;
    static /* synthetic */ Class class$VASSAL$build$module$Documentation;
    static /* synthetic */ Class class$VASSAL$build$module$PlayerRoster;
    static /* synthetic */ Class class$VASSAL$build$module$GlobalOptions;
    static /* synthetic */ Class class$VASSAL$build$module$Map;
    static /* synthetic */ Class class$VASSAL$build$module$PrototypesContainer;
    static /* synthetic */ Class class$VASSAL$build$module$PieceWindow;
    static /* synthetic */ Class class$VASSAL$build$module$Chatter;

    protected BasicModule(DataArchive dataArchive, Prefs prefs) {
        super(dataArchive);
        this.setGlobalPrefs(prefs);
    }

    protected void build() throws IOException {
        Object object;
        InputStream inputStream;
        block6: {
            String string = "buildFile";
            inputStream = null;
            try {
                inputStream = this.getDataArchive().getFileStream(string);
            }
            catch (IOException iOException) {
                if (!new File(this.getDataArchive().getName()).exists()) break block6;
                throw new IOException("Not a VASSAL module");
            }
        }
        try {
            if (inputStream == null) {
                this.build(null);
            } else {
                object = Builder.createDocument(inputStream);
                this.build(object.getDocumentElement());
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage());
        }
        this.getFileMenu().add(this.getPrefs().getEditor().getEditAction());
        object = new JMenuItem("Quit");
        ((AbstractButton)object).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicModule.this.quit();
            }
        });
        ((AbstractButton)object).setMnemonic('Q');
        this.getFileMenu().add((JMenuItem)object);
    }

    public void build(Element element) {
        if (element != null) {
            this.gameName = element.getAttribute("name");
            if (element.getAttribute("VassalVersion").length() > 0) {
                this.vassalVersionCreated = element.getAttribute("VassalVersion");
            }
        }
        this.initGameState();
        this.initLogger();
        this.initServer();
        if (element != null) {
            super.build(element);
            this.ensureComponent(class$VASSAL$build$module$gamepieceimage$GamePieceImageDefinitions == null ? (class$VASSAL$build$module$gamepieceimage$GamePieceImageDefinitions = BasicModule.class$("VASSAL.build.module.gamepieceimage.GamePieceImageDefinitions")) : class$VASSAL$build$module$gamepieceimage$GamePieceImageDefinitions);
            this.ensureComponent(class$VASSAL$build$module$properties$GlobalProperties == null ? (class$VASSAL$build$module$properties$GlobalProperties = BasicModule.class$("VASSAL.build.module.properties.GlobalProperties")) : class$VASSAL$build$module$properties$GlobalProperties);
        } else {
            this.buildDefaultComponents();
        }
        this.initFrame();
    }

    protected void initServer() {
        ChatServerFactory.register("default", NodeClientFactory.getInstance());
        ChatServerFactory.register("node", NodeClientFactory.getInstance());
        this.server = new DynamicClient();
        ChatServerControls chatServerControls = new ChatServerControls();
        chatServerControls.addTo(this);
    }

    protected void initLogger() {
        this.logger = new BasicLogger();
        ((BasicLogger)this.logger).build(null);
        ((BasicLogger)this.logger).addTo(this);
    }

    protected void initGameState() {
        this.theState = new GameState();
        this.theState.addTo(this);
        this.addCommandEncoder(this.theState);
    }

    public Command decode(String string) {
        if (string == null) {
            return null;
        }
        Command command = null;
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, COMMAND_SEPARATOR);
        String string2 = decoder.nextToken();
        if (string.equals(string2)) {
            command = this.decodeSubCommand(string2);
        } else {
            Command command2 = null;
            command = this.decode(string2);
            while (decoder.hasMoreTokens()) {
                command2 = this.decode(decoder.nextToken());
                command = command == null ? command2 : command.append(command2);
            }
        }
        return command;
    }

    private Command decodeSubCommand(String string) {
        Command command = null;
        for (int i = 0; i < this.commandEncoders.length && command == null; ++i) {
            command = this.commandEncoders[i].decode(string);
        }
        return command;
    }

    public String encode(Command command) {
        if (command == null) {
            return null;
        }
        String string = this.encodeSubCommand(command);
        Command[] commandArray = command.getSubCommands();
        if (commandArray.length > 0) {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(string, COMMAND_SEPARATOR);
            for (int i = 0; i < commandArray.length; ++i) {
                String string2 = this.encode(commandArray[i]);
                if (string2 == null) continue;
                sequenceEncoder.append(string2);
            }
            string = sequenceEncoder.getValue();
        }
        return string;
    }

    private String encodeSubCommand(Command command) {
        String string = null;
        for (int i = 0; i < this.commandEncoders.length && string == null; ++i) {
            string = this.commandEncoders[i].encode(command);
        }
        return string;
    }

    protected void buildDefaultComponents() {
        this.addComponent(class$VASSAL$build$module$BasicCommandEncoder == null ? (class$VASSAL$build$module$BasicCommandEncoder = BasicModule.class$("VASSAL.build.module.BasicCommandEncoder")) : class$VASSAL$build$module$BasicCommandEncoder);
        this.addComponent(class$VASSAL$build$module$Documentation == null ? (class$VASSAL$build$module$Documentation = BasicModule.class$("VASSAL.build.module.Documentation")) : class$VASSAL$build$module$Documentation);
        this.addComponent(class$VASSAL$build$module$PlayerRoster == null ? (class$VASSAL$build$module$PlayerRoster = BasicModule.class$("VASSAL.build.module.PlayerRoster")) : class$VASSAL$build$module$PlayerRoster);
        this.addComponent(class$VASSAL$build$module$GlobalOptions == null ? (class$VASSAL$build$module$GlobalOptions = BasicModule.class$("VASSAL.build.module.GlobalOptions")) : class$VASSAL$build$module$GlobalOptions);
        this.addComponent(class$VASSAL$build$module$Map == null ? (class$VASSAL$build$module$Map = BasicModule.class$("VASSAL.build.module.Map")) : class$VASSAL$build$module$Map);
        this.addComponent(class$VASSAL$build$module$gamepieceimage$GamePieceImageDefinitions == null ? (class$VASSAL$build$module$gamepieceimage$GamePieceImageDefinitions = BasicModule.class$("VASSAL.build.module.gamepieceimage.GamePieceImageDefinitions")) : class$VASSAL$build$module$gamepieceimage$GamePieceImageDefinitions);
        this.addComponent(class$VASSAL$build$module$properties$GlobalProperties == null ? (class$VASSAL$build$module$properties$GlobalProperties = BasicModule.class$("VASSAL.build.module.properties.GlobalProperties")) : class$VASSAL$build$module$properties$GlobalProperties);
        this.addComponent(class$VASSAL$build$module$PrototypesContainer == null ? (class$VASSAL$build$module$PrototypesContainer = BasicModule.class$("VASSAL.build.module.PrototypesContainer")) : class$VASSAL$build$module$PrototypesContainer);
        this.addComponent(class$VASSAL$build$module$PieceWindow == null ? (class$VASSAL$build$module$PieceWindow = BasicModule.class$("VASSAL.build.module.PieceWindow")) : class$VASSAL$build$module$PieceWindow);
        this.addComponent(class$VASSAL$build$module$Chatter == null ? (class$VASSAL$build$module$Chatter = BasicModule.class$("VASSAL.build.module.Chatter")) : class$VASSAL$build$module$Chatter);
    }

    protected void initFrame() {
        Rectangle rectangle = Info.getScreenBounds(this.frame);
        String string = "BoundsOfGameModule";
        if (GlobalOptions.getInstance().isUseSingleWindow()) {
            ((Component)this.frame).setLocation(rectangle.getLocation());
            ((Component)this.frame).setSize(rectangle.width, rectangle.height / 3);
        } else {
            Rectangle rectangle2 = new Rectangle(0, 0, rectangle.width, rectangle.height / 4);
            this.getPrefs().addOption(new PositionOption(string, this.frame, rectangle2));
        }
        ((Component)this.frame).setVisible(true);
        this.warn(this.gameName + " version " + this.moduleVersion);
        System.err.println("-- " + this.gameName + " version " + this.moduleVersion);
        this.frame.setTitle(this.gameName);
    }

    protected void ensureComponent(Class clazz) {
        if (!this.getComponents(clazz).hasMoreElements()) {
            this.addComponent(clazz);
        }
    }

    protected void addComponent(Class clazz) {
        try {
            Buildable buildable = (Buildable)clazz.newInstance();
            buildable.build(null);
            buildable.addTo(this);
            this.add(buildable);
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

