/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.build.GameModule;
import VASSAL.build.IllegalBuildException;
import VASSAL.build.module.ExtensionsLoader;
import VASSAL.build.module.ModuleExtension;
import VASSAL.build.module.ServerConnection;
import VASSAL.configure.ExtensionEditWindow;
import VASSAL.configure.ModuleEditWindow;
import VASSAL.launch.BasicModule;
import VASSAL.launch.ResourceExtracter;
import VASSAL.preferences.Prefs;
import VASSAL.preferences.PrefsEditor;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.DataArchive;
import VASSAL.tools.ErrorLog;
import VASSAL.tools.JarArchive;
import VASSAL.tools.SplashScreen;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.ZipFile;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class Main {
    public static final String BUILT_IN = "auto";
    public static final String EXTENSION_LIST = "autoExtensions";
    public static final String LOCAL_INSTALL = "localInstall";
    protected Properties properties;
    protected PrefsEditor editor;
    protected boolean isFirstTime;
    protected boolean builtInModule;
    protected Prefs globalPrefs;
    protected File homeDir;
    static /* synthetic */ Class class$VASSAL$launch$Main;

    public Main(final String[] stringArray) {
        System.setProperty("swing.aatext", "true");
        System.setProperty("swing.boldMetal", "false");
        this.initHomeDir();
        this.initProperties();
        System.err.println("-- OS " + System.getProperty("os.name"));
        System.err.println("-- Java version " + System.getProperty("java.version"));
        String string = this.getVersion();
        System.err.println("-- VASSAL version " + string);
        Thread thread = new Thread(new ErrorLog.Group(), "Main Thread"){

            public void run() {
                Runnable runnable = new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        1.access$100(this.this$1).init(1.access$000(this.this$1));
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }

            static /* synthetic */ String[] access$000(1 var0) {
                return var0.stringArray;
            }

            static /* synthetic */ Main access$100(1 var0) {
                return var0.Main.this;
            }
        };
        thread.start();
    }

    protected String getVersion() {
        return Info.getVersion();
    }

    protected void init(final String[] stringArray) {
        this.properties = this.parseArgs(stringArray);
        File file = this.initPrefsFile();
        boolean bl = this.isFirstTime = !file.exists();
        if (this.isFirstTime) {
            this.showLicense();
        }
        this.builtInModule = ((Hashtable)this.properties).get(BUILT_IN) != null;
        final File file2 = ((Hashtable)this.properties).get(LOCAL_INSTALL) != null ? new File(System.getProperty("user.dir")) : null;
        this.editor = new PrefsEditor(new ArchiveWriter(file.getPath()));
        this.globalPrefs = new Prefs(this.editor, "VASSAL");
        final String[] stringArray2 = this.getExtractTargets(stringArray);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){
            protected int next = 0;

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (++this.next < stringArray2.length) {
                    Main.this.extractResource(stringArray2[this.next], this, Main.this.globalPrefs, file2);
                } else {
                    Main.this.launchVassal(Main.this.globalPrefs, stringArray);
                }
            }
        };
        if (stringArray2.length > 0) {
            this.extractResource(stringArray2[0], propertyChangeListener, this.globalPrefs, file2);
        } else {
            this.launchVassal(this.globalPrefs, stringArray);
        }
    }

    protected Properties parseArgs(String[] stringArray) {
        Properties properties = new Properties();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith("-")) continue;
            if (i < stringArray.length - 1 && !stringArray[i + 1].startsWith("-")) {
                ((Hashtable)properties).put(stringArray[i].substring(1), stringArray[++i]);
                continue;
            }
            ((Hashtable)properties).put(stringArray[i].substring(1), "");
        }
        return properties;
    }

    protected File initPrefsFile() {
        File file = new File(this.homeDir, "Preferences");
        File file2 = new File(System.getProperty("user.home") + File.separator + ".VassalPreferences");
        if (!file.exists() && file2.exists()) {
            file2.renameTo(file);
        }
        return file;
    }

    protected void initHomeDir() {
        this.homeDir = new File(System.getProperty("user.home"), "VASSAL");
        if (!this.homeDir.exists()) {
            this.homeDir.mkdir();
        } else if (!this.homeDir.isDirectory()) {
            this.homeDir.delete();
            this.homeDir.mkdir();
        }
    }

    protected void newExtension() {
        ModuleExtension moduleExtension = new ModuleExtension(new ArchiveWriter((String)null));
        moduleExtension.build();
        ((Component)new ExtensionEditWindow(moduleExtension)).setVisible(true);
    }

    protected void loadExtension(File file) throws IllegalBuildException, IOException {
        ModuleExtension moduleExtension = new ModuleExtension(new ArchiveWriter(new ZipFile(file.getPath())));
        moduleExtension.build();
        ((Component)new ExtensionEditWindow(moduleExtension)).setVisible(true);
    }

    protected void newModule() throws IOException {
        GameModule.init(new BasicModule(new ArchiveWriter((String)null), this.globalPrefs));
        ((Component)new ModuleEditWindow()).setVisible(true);
    }

    protected void edit(File file) throws IOException {
        ArchiveWriter archiveWriter = new ArchiveWriter(new ZipFile(file.getPath()));
        BasicModule basicModule = new BasicModule(archiveWriter, this.globalPrefs);
        basicModule.setGlobalPrefs(this.globalPrefs);
        GameModule.init(basicModule);
        ((Component)new ModuleEditWindow()).setVisible(true);
    }

    protected void quit() {
        if (GameModule.getGameModule() != null) {
            GameModule.getGameModule().quit();
        } else {
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        new Main(stringArray);
    }

    protected void initProperties() {
        if (System.getProperty("stderr") == null) {
            System.setProperty("stderr", System.getProperty("user.home") + File.separator + "VASSAL" + File.separator + "errorLog");
        }
        if (!"null".equals(System.getProperty("stderr"))) {
            try {
                System.setErr(new PrintStream(new FileOutputStream(System.getProperty("stderr"))));
            }
            catch (IOException iOException) {
                System.err.println("Unable to redirect stderr to " + System.getProperty("stderr"));
            }
        }
        ((Hashtable)System.getProperties()).put("sun.awt.exception.handler", "VASSAL.tools.ErrorLog");
        if (System.getProperty("http.proxyHost") == null && System.getProperty("proxyHost") != null) {
            System.setProperty("http.proxyHost", System.getProperty("proxyHost"));
        }
        if (System.getProperty("http.proxyPort") == null && System.getProperty("proxyPort") != null) {
            System.setProperty("http.proxyPort", System.getProperty("proxyPort"));
        }
    }

    protected void showLicense() {
        try {
            final JDialog jDialog = new JDialog((java.awt.Frame)null, true);
            jDialog.setDefaultCloseOperation(0);
            jDialog.setTitle("License Agreement");
            jDialog.getContentPane().setLayout(new BoxLayout(jDialog.getContentPane(), 1));
            final JTextArea jTextArea = new JTextArea(20, 40);
            jTextArea.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            jDialog.getContentPane().add(jScrollPane);
            Box box = Box.createHorizontalBox();
            JButton jButton = new JButton("Accept");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jDialog.dispose();
                }
            });
            JButton jButton2 = new JButton("Decline");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    System.exit(0);
                }
            });
            box.add(jButton);
            box.add(jButton2);
            jDialog.getContentPane().add(box);
            InputStream inputStream = (class$VASSAL$launch$Main == null ? (class$VASSAL$launch$Main = Main.class$("VASSAL.launch.Main")) : class$VASSAL$launch$Main).getResourceAsStream("/LICENSE.txt");
            if (inputStream != null) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    jTextArea.append(string + '\n');
                }
                jDialog.pack();
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                ((Component)jDialog).setLocation(dimension.width / 2 - jDialog.getSize().width / 2, dimension.height / 2 - jDialog.getSize().height / 2);
                Runnable runnable = new Runnable(){

                    public void run() {
                        jTextArea.scrollRectToVisible(new Rectangle());
                    }
                };
                SwingUtilities.invokeLater(runnable);
                ((Component)jDialog).setVisible(true);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void extractResource(String string, PropertyChangeListener propertyChangeListener, Prefs prefs, File file) {
        Properties properties = new Properties();
        InputStream inputStream = (class$VASSAL$launch$Main == null ? (class$VASSAL$launch$Main = Main.class$("VASSAL.launch.Main")) : class$VASSAL$launch$Main).getResourceAsStream(string);
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        new ResourceExtracter(prefs, properties, propertyChangeListener, file).install();
    }

    protected String[] getExtractTargets(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith("-ext") || i >= stringArray.length - 1) continue;
            arrayList.add(stringArray[i + 1]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected void launchVassal(Prefs prefs, String[] stringArray) {
        block15: {
            if (this.properties.getProperty("install") != null) {
                System.exit(0);
            } else {
                final File file = this.getModuleFile(this.properties, prefs, stringArray);
                if (this.builtInModule || file != null && file.exists()) {
                    final String string = this.properties.getProperty("load");
                    try {
                        if (this.properties.getProperty("edit") != null) {
                            this.edit(file);
                            break block15;
                        }
                        final DataArchive dataArchive = this.initArchive(file);
                        Component component = null;
                        final Observer observer = new Observer(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void update(Observable observable, Object object) {
                                try {
                                    Main.this.loadModule(dataArchive, true, Main.this.properties);
                                    if (string != null) {
                                        GameModule.getGameModule().getGameState().loadGame(new File(string));
                                    }
                                }
                                catch (IOException iOException) {
                                    JOptionPane.showMessageDialog(null, "Unable to open module " + file.getPath());
                                    ((Component)new Frame()).setVisible(true);
                                }
                                finally {
                                    if (object instanceof SplashScreen) {
                                        ((SplashScreen)object).dispose();
                                    }
                                }
                            }
                        };
                        try {
                            component = new SplashScreen(dataArchive.getCachedImage("Splash.gif")){
                                protected boolean triggered = false;

                                public void paint(Graphics graphics) {
                                    super.paint(graphics);
                                    if (!this.triggered) {
                                        this.triggered = true;
                                        observer.update(null, this);
                                    }
                                }
                            };
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (component != null && component.getWidth() * component.getHeight() > 0) {
                            ((SplashScreen)component).setVisible(true);
                            break block15;
                        }
                        observer.update(null, null);
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(null, "Unable to open module " + file.getPath());
                        ((Component)new Frame()).setVisible(true);
                    }
                } else {
                    if (file != null) {
                        JOptionPane.showMessageDialog(null, file.getPath() + " not found");
                    }
                    if (this.isFirstTime) {
                        String string = prefs.getStoredValue("docsDirectory");
                        File file2 = string != null ? new File(string) : null;
                        File file3 = new File(file2, "tour.mod");
                        File file4 = new File(file2, "tour.log");
                        if (file3.exists() && file4.exists()) {
                            this.loadTour(file3, file4);
                        } else {
                            ((Component)new Frame()).setVisible(true);
                        }
                    } else {
                        ((Component)new Frame()).setVisible(true);
                    }
                }
            }
        }
    }

    protected File getModuleFile(Properties properties, Prefs prefs, String[] stringArray) {
        String string = null;
        switch (stringArray.length) {
            case 0: {
                break;
            }
            case 1: {
                string = stringArray[0].startsWith("-") ? null : stringArray[0];
                break;
            }
            default: {
                string = properties.getProperty("edit");
                if (string != null || stringArray[stringArray.length - 1].startsWith("-") || stringArray[stringArray.length - 2].startsWith("-")) break;
                string = stringArray[stringArray.length - 1];
            }
        }
        File file = null;
        if (string != null) {
            String string2 = properties.getProperty("moduleDir");
            file = string2 != null ? new File(prefs.getStoredValue(string2), string) : new File(string);
        }
        return file;
    }

    protected void loadTour(final File file, final File file2) {
        final JFrame jFrame = new JFrame();
        jFrame.getContentPane().setLayout(new BoxLayout(jFrame.getContentPane(), 1));
        JLabel jLabel = new JLabel();
        jLabel.setFont(new Font("SansSerif", 1, 40));
        jLabel.setText("Welcome to VASSAL");
        jLabel.setForeground(Color.black);
        jLabel.setAlignmentX(0.5f);
        jFrame.getContentPane().add(jLabel);
        Box box = Box.createHorizontalBox();
        JButton jButton = new JButton("Take the tour");
        JButton jButton2 = new JButton("Jump right in");
        box.add(jButton);
        box.add(jButton2);
        JPanel jPanel = new JPanel();
        jPanel.add(box);
        jFrame.getContentPane().add(jPanel);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jFrame.dispose();
                try {
                    GameModule.init(new BasicModule(Main.this.initArchive(file), Main.this.globalPrefs));
                    GameModule.getGameModule().getGameState().loadGame(file2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(null, exception.getMessage(), "Error opening module", 0);
                    ((Component)new Frame()).setVisible(true);
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jFrame.dispose();
                ((Component)new Frame()).setVisible(true);
            }
        });
        jFrame.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)jFrame).setLocation(dimension.width / 2 - jFrame.getSize().width / 2, dimension.height / 2 - jFrame.getSize().height);
        ((Component)jFrame).setVisible(true);
    }

    protected void loadModule(DataArchive dataArchive, boolean bl, Properties properties) throws IOException {
        GameModule.init(new BasicModule(dataArchive, this.globalPrefs));
        if (bl) {
            String string = properties.getProperty(EXTENSION_LIST);
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    this.loadExtension(string2);
                }
            } else {
                new ExtensionsLoader().addTo(GameModule.getGameModule());
            }
        }
    }

    protected void loadExtension(String string) {
        new ModuleExtension(new JarArchive(string)).build();
    }

    protected DataArchive initArchive(File file) throws IOException {
        DataArchive dataArchive = this.builtInModule ? new JarArchive() : new DataArchive(file.getPath());
        return dataArchive;
    }

    protected ServerConnection initClient() {
        return null;
    }

    protected Action initShowServerStatusAction() {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class Frame
    extends JFrame {
        protected JButton openButton;
        protected JButton editButton;
        protected JButton newButton;
        protected JLabel splash;
        protected Color fgColor = Color.black;
        protected JFileChooser fc;

        public Frame() {
            super("VASSAL");
            this.initComponents();
            this.pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            ((Component)this).setLocation(dimension.width / 2 - this.getSize().width / 2, dimension.height / 2 - this.getSize().height / 2);
            String string = Main.this.globalPrefs.getStoredValue("docsDirectory");
            if (string == null) {
                string = System.getProperty("user.home");
            }
            this.fc = new JFileChooser(string);
        }

        protected void initComponents() {
            JComponent jComponent;
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ Frame this$1;
                {
                    this.this$1 = frame;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    Frame.access$200(this.this$1).quit();
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            this.splash = new JLabel();
            this.splash.setAlignmentX(0.5f);
            this.splash.setText("VASSAL");
            this.splash.setFont(new Font("SansSerif", 1, 48));
            this.splash.setName("splash");
            this.splash.setForeground(this.fgColor);
            jPanel.add(this.splash);
            JLabel jLabel = new JLabel("version " + Info.getVersion());
            jLabel.setAlignmentX(0.5f);
            jLabel.setFont(new Font("SansSerif", 1, 12));
            jLabel.setForeground(this.fgColor);
            jPanel.add(jLabel);
            Box box = Box.createHorizontalBox();
            this.openButton = new JButton();
            this.openButton.setText("Play Module");
            this.openButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ Frame this$1;
                {
                    this.this$1 = frame;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        File file = this.this$1.chooseFile();
                        if (file != null) {
                            Frame.access$200(this.this$1).loadModule(Frame.access$200(this.this$1).initArchive(file), true, Frame.access$200((Frame)this.this$1).properties);
                            if (GameModule.getGameModule() != null) {
                                this.this$1.dispose();
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        JOptionPane.showMessageDialog(this.this$1, exception.getMessage(), "Error opening module", 0);
                    }
                }
            });
            box.add(this.openButton);
            Action action = Main.this.initShowServerStatusAction();
            if (action != null) {
                jComponent = new JButton((String)action.getValue("Name"));
                ((AbstractButton)jComponent).addActionListener(action);
                box.add(jComponent);
            }
            jPanel.add(box);
            box = Box.createHorizontalBox();
            this.editButton = new JButton();
            this.editButton.setText("Edit Module");
            this.editButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ Frame this$1;
                {
                    this.this$1 = frame;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    File file = this.this$1.chooseFile();
                    if (file != null) {
                        try {
                            Frame.access$200(this.this$1).edit(file);
                            this.this$1.dispose();
                        }
                        catch (IOException iOException) {
                            JOptionPane.showMessageDialog(this.this$1, iOException.getMessage(), "Load Error", 0);
                        }
                    }
                }
            });
            box.add(this.editButton);
            this.newButton = new JButton();
            this.newButton.setText("New Module");
            this.newButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ Frame this$1;
                {
                    this.this$1 = frame;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        Frame.access$200(this.this$1).newModule();
                        this.this$1.dispose();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        JOptionPane.showMessageDialog(this.this$1, iOException.getMessage(), "Error creating module", 0);
                    }
                }
            });
            box.add(this.newButton);
            box.setBorder(new TitledBorder("Module Design"));
            jPanel.add(box);
            jComponent = new JPanel();
            jComponent.setLayout(new BoxLayout(jComponent, 0));
            JButton jButton = new JButton("Load Module");
            JButton jButton2 = new JButton("Edit");
            jButton2.setEnabled(false);
            JButton jButton3 = new JButton("New");
            jButton3.setEnabled(false);
            jButton.addActionListener(new ActionListener(this, jButton, jButton2, jButton3){
                private final /* synthetic */ JButton val$loadModule;
                private final /* synthetic */ JButton val$loadExtension;
                private final /* synthetic */ JButton val$newExtension;
                private final /* synthetic */ Frame this$1;
                {
                    this.this$1 = frame;
                    this.val$loadModule = jButton;
                    this.val$loadExtension = jButton2;
                    this.val$newExtension = jButton3;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        File file = this.this$1.chooseFile();
                        if (file != null) {
                            Frame.access$200(this.this$1).loadModule(Frame.access$200(this.this$1).initArchive(file), false, Frame.access$200((Frame)this.this$1).properties);
                            this.val$loadModule.setEnabled(false);
                            this.val$loadExtension.setEnabled(true);
                            this.val$newExtension.setEnabled(true);
                        }
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(this.this$1, iOException.getMessage(), "Error opening module", 0);
                    }
                }
            });
            jButton2.addActionListener(new ActionListener(this){
                private final /* synthetic */ Frame this$1;
                {
                    this.this$1 = frame;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    File file = this.this$1.chooseFile();
                    if (file != null) {
                        try {
                            Frame.access$200(this.this$1).loadExtension(file);
                            this.this$1.dispose();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            JOptionPane.showMessageDialog(this.this$1, "Unable to load " + file.getName() + "\n." + exception.getMessage(), "Load failed", 0);
                        }
                    }
                }
            });
            jButton3.addActionListener(new ActionListener(this){
                private final /* synthetic */ Frame this$1;
                {
                    this.this$1 = frame;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Frame.access$200(this.this$1).newExtension();
                    this.this$1.dispose();
                }
            });
            jComponent.add(jButton);
            jComponent.add(jButton2);
            jComponent.add(jButton3);
            jComponent.setBorder(new TitledBorder("Extension Design"));
            jPanel.add(jComponent);
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            this.getContentPane().add(jPanel);
        }

        protected File chooseFile() {
            if (this.fc.showOpenDialog(this) == 0) {
                if (!this.fc.getSelectedFile().exists()) {
                    JOptionPane.showMessageDialog(this, this.fc.getSelectedFile() + " not found");
                    return null;
                }
                return this.fc.getSelectedFile();
            }
            return null;
        }

        static /* synthetic */ Main access$200(Frame frame) {
            return frame.Main.this;
        }
    }
}

