/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.configure.DirectoryConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.preferences.Prefs;
import VASSAL.preferences.PrefsEditor;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.DataArchive;
import VASSAL.tools.SequenceEncoder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;

public class ResourceExtracter {
    private File destinationDir;
    private JProgressBar bar;
    private JWindow monitor;
    private Prefs prefs;
    private Properties props;
    public static final String ZIP_RESOURCE_NAME = "resource";
    public static final String RESOURCE_LIST = "extractList";
    public static final String ASSEMBLE_TARGET = "assembleTo";
    public static final String UPDATE_PROMPT_MSG = "prompt";
    public static final String FIRST_TIME_PROMPT = "initialPrompt";
    public static final String VERSION_ID = "checksum";
    public static final String VERSION_ID_PROPERTY = "checksumKey";
    public static final String INSTALL_DIR_PROPERTY = "installDirKey";
    public static final String REQUIRED = "required";
    public static final String STATUS = "status";
    public static final String SUCCESSFUL = "successful";
    public static final String FAILED = "failed";
    private PropertyChangeListener listener;
    private String versionIdKey;
    private String installDirKey;
    private JLabel label;

    public ResourceExtracter(Prefs prefs, Properties properties, PropertyChangeListener propertyChangeListener) {
        this(prefs, properties, propertyChangeListener, null);
    }

    public ResourceExtracter(Prefs prefs, Properties properties, PropertyChangeListener propertyChangeListener, File file) {
        this.destinationDir = file;
        this.listener = propertyChangeListener;
        this.prefs = prefs;
        this.props = properties;
        this.versionIdKey = properties.getProperty(VERSION_ID_PROPERTY);
        if (this.versionIdKey == null) {
            throw new IllegalArgumentException("Must specify checksumKey");
        }
        this.installDirKey = properties.getProperty(INSTALL_DIR_PROPERTY);
        if (this.installDirKey == null) {
            throw new IllegalArgumentException("Must specify installDirKey");
        }
        prefs.addOption(null, new StringConfigurer(this.versionIdKey, null));
        DirectoryConfigurer directoryConfigurer = new DirectoryConfigurer(this.installDirKey, null);
        directoryConfigurer.setValue((Object)null);
        prefs.addOption(null, directoryConfigurer);
    }

    protected File chooseInstallDir() {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.home"));
        jFileChooser.setSelectedFile((File)this.prefs.getValue(this.installDirKey));
        jFileChooser.setFileSelectionMode(1);
        boolean bl = !this.isInitialInstall();
        File file = null;
        while (file == null) {
            if (jFileChooser.showOpenDialog(null) == 1 && bl) {
                file = null;
                break;
            }
            file = jFileChooser.getSelectedFile();
            if (file == null) continue;
            if (!file.exists()) {
                switch (JOptionPane.showConfirmDialog(null, file.getName() + " does not exist.  Create?", "Create directory", 0)) {
                    case 0: {
                        if (file.mkdir()) break;
                        file = null;
                        break;
                    }
                    case 1: {
                        file = null;
                    }
                }
                continue;
            }
            if (file.isDirectory()) continue;
            JOptionPane.showMessageDialog(null, file.getName() + " is not a directory", "Not a directory", 0);
            file = null;
        }
        return file;
    }

    protected String getPromptMessage() {
        String string;
        String string2 = string = this.isInitialInstall() ? this.props.getProperty(FIRST_TIME_PROMPT) : this.props.getProperty(UPDATE_PROMPT_MSG);
        if (string == null) {
            return string;
        }
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '|');
        StringBuffer stringBuffer = new StringBuffer();
        while (decoder.hasMoreTokens()) {
            stringBuffer.append(decoder.nextToken());
            if (!decoder.hasMoreTokens()) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    protected boolean isUpToDate() {
        File file;
        boolean bl = false;
        String string = this.props.getProperty(VERSION_ID, "");
        if (string.equals(this.prefs.getValue(this.versionIdKey)) && (file = (File)this.prefs.getValue(this.installDirKey)) != null && file.exists()) {
            bl = this.props.getProperty(REQUIRED) != null ? new File(file, this.props.getProperty(REQUIRED)).exists() : true;
        }
        return bl;
    }

    protected boolean isInitialInstall() {
        Object object = this.prefs.getValue(this.versionIdKey);
        return object == null || "".equals(object);
    }

    public void install() {
        Serializable serializable;
        if (this.isUpToDate()) {
            this.installSkipped();
            return;
        }
        if (!this.confirmInstall()) {
            this.installSkipped();
            return;
        }
        if (this.destinationDir == null) {
            serializable = (File)this.prefs.getValue(this.installDirKey);
            this.destinationDir = serializable != null && ((File)serializable).exists() && ((File)serializable).isDirectory() ? serializable : this.chooseInstallDir();
        }
        if (this.destinationDir != null) {
            this.bar = new JProgressBar(0, 1);
            this.bar.setPreferredSize(new Dimension(400, this.bar.getPreferredSize().height));
            this.bar.setAlignmentX(0.0f);
            this.monitor = new JWindow();
            serializable = new JPanel();
            ((Container)serializable).setLayout(new BoxLayout((Container)serializable, 1));
            ((JComponent)serializable).setBackground(Color.white);
            this.label = new JLabel("Installing ...");
            this.label.setHorizontalTextPosition(2);
            this.label.setBackground(Color.white);
            this.label.setForeground(Color.black);
            this.label.setAlignmentX(0.0f);
            ((Container)serializable).add(this.label);
            ((Container)serializable).add(this.bar);
            ((JComponent)serializable).setBorder(new BevelBorder(0, Color.lightGray, Color.darkGray));
            this.monitor.getContentPane().add((Component)serializable);
            this.monitor.pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            ((Component)this.monitor).setLocation(dimension.width / 2 - this.monitor.getWidth() / 2, dimension.height / 2 - this.monitor.getHeight() / 2);
            ((Component)this.monitor).setVisible(true);
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        ResourceExtracter.this.extract();
                        ResourceExtracter.this.storeInstallInfo();
                        ResourceExtracter.this.installSucceeded();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        String string = iOException.getMessage();
                        if (string == null || string.length() == 0) {
                            string = iOException.getClass().getName().substring(iOException.getClass().getName().lastIndexOf("."));
                        }
                        ResourceExtracter.this.installFailed(string);
                    }
                }
            };
            new Thread(runnable).start();
        } else {
            this.installSkipped();
        }
    }

    protected boolean confirmInstall() {
        String string = this.getPromptMessage();
        if (string == null) {
            return true;
        }
        if (this.isInitialInstall()) {
            if (this.destinationDir == null) {
                JOptionPane.showOptionDialog(null, string, "Install", -1, 3, null, new String[]{"Select"}, "Select");
            }
            return true;
        }
        return 0 == JOptionPane.showConfirmDialog(null, string, "Update", 0);
    }

    protected void storeInstallInfo() throws IOException {
        this.prefs.getOption(this.versionIdKey).setValue(this.props.getProperty(VERSION_ID));
        this.prefs.getOption(this.installDirKey).setValue(this.destinationDir);
        this.prefs.write();
    }

    protected void installSucceeded() {
        Runnable runnable = new Runnable(){

            public void run() {
                if (ResourceExtracter.this.monitor != null) {
                    ResourceExtracter.this.monitor.dispose();
                }
                String string = ResourceExtracter.this.isInitialInstall() ? "Installation Complete" : "Update complete";
                JOptionPane.showMessageDialog(null, string, "Success", 1);
                ResourceExtracter.this.listener.propertyChange(new PropertyChangeEvent(this, ResourceExtracter.STATUS, null, ResourceExtracter.SUCCESSFUL));
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    protected void installSkipped() {
        Runnable runnable = new Runnable(){

            public void run() {
                ResourceExtracter.this.listener.propertyChange(new PropertyChangeEvent(this, ResourceExtracter.STATUS, null, ResourceExtracter.SUCCESSFUL));
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    protected void installFailed(final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                ResourceExtracter.this.monitor.dispose();
                JOptionPane.showMessageDialog(null, "Unable to install.\n" + string, "Install failed", 0);
                ResourceExtracter.this.listener.propertyChange(new PropertyChangeEvent(this, ResourceExtracter.STATUS, null, ResourceExtracter.FAILED));
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void extract() throws IOException {
        if (this.getZipResource() != null) {
            this.extractZipContents();
        } else if (this.getResourceList() != null) {
            if (this.getAssembleTarget() != null) {
                this.packResourceList();
            } else {
                this.extractResourceList();
            }
        }
    }

    private void extractResourceList() throws IOException {
        this.label.setText("Unpacking");
        List list = this.getListedResources();
        this.bar.setMaximum(list.size());
        InputStream inputStream = null;
        int n = 0;
        byte[] byArray = new byte[10000];
        int n2 = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.label.setText(string);
            this.bar.setValue(++n);
            File file = new File(this.destinationDir, string);
            this.createDir(file.getParentFile());
            inputStream = this.getClass().getResourceAsStream("/" + string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            while ((n2 = inputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n2);
            }
            fileOutputStream.close();
        }
    }

    protected List getListedResources() throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(this.getResourceList())));
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            arrayList.add(string);
        }
        return arrayList;
    }

    protected String getResourceList() {
        return this.props.getProperty(RESOURCE_LIST);
    }

    private void packResourceList() throws IOException {
        this.label.setText("Unpacking");
        File file = File.createTempFile("Vdata", ".zip");
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        File file2 = this.getAssembleTarget();
        List list = this.getListedResources();
        int n = 0;
        this.bar.setMaximum(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.label.setText(string);
            byte[] byArray = DataArchive.getBytes(this.getClass().getResourceAsStream("/" + string));
            ZipEntry zipEntry = new ZipEntry(string);
            zipEntry.setMethod(0);
            zipEntry.setSize(byArray.length);
            CRC32 cRC32 = new CRC32();
            cRC32.update(byArray);
            zipEntry.setCrc(cRC32.getValue());
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(byArray);
            this.bar.setValue(++n);
        }
        this.label.setText("Saving");
        zipOutputStream.close();
        if (file2.exists() && !file2.renameTo(this.getBackupAssembleTarget())) {
            throw new IOException("Unable to back up " + file2.getPath());
        }
        if (!file.renameTo(file2)) {
            throw new IOException("Unable to create " + file2.getPath() + ".\nPlease copy from " + file.getPath());
        }
    }

    protected File getAssembleTarget() {
        String string = this.props.getProperty(ASSEMBLE_TARGET);
        return string != null ? new File(this.destinationDir, string) : null;
    }

    protected File getBackupAssembleTarget() {
        File file = this.getAssembleTarget();
        String string = (String)this.prefs.getValue(this.versionIdKey);
        if (string == null) {
            string = "backup";
        }
        int n = file.getName().lastIndexOf(46);
        String string2 = file.getName().substring(0, n) + "-" + string + file.getName().substring(n);
        return new File(file.getParentFile(), string2);
    }

    private void extractZipContents() throws IOException {
        ZipEntry zipEntry;
        this.label.setText("Unpacking");
        File file = File.createTempFile("Vdata", ".zip");
        byte[] byArray = new byte[100000];
        InputStream inputStream = this.getClass().getResourceAsStream(this.getZipResource());
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        int n = 0;
        while ((n = inputStream.read(byArray)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        inputStream.close();
        ((OutputStream)fileOutputStream).close();
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
        this.bar.setMaximum(new ZipFile(file).size());
        int n2 = 0;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            this.label.setText(zipEntry.getName());
            this.bar.setValue(++n2);
            File file2 = new File(this.destinationDir, zipEntry.getName());
            if (zipEntry.isDirectory()) {
                this.createDir(file2);
                continue;
            }
            this.createDir(file2.getParentFile());
            fileOutputStream = new FileOutputStream(file2);
            n = 0;
            while ((n = zipInputStream.read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            ((OutputStream)fileOutputStream).close();
        }
    }

    protected String getZipResource() {
        return this.props.getProperty(ZIP_RESOURCE_NAME);
    }

    private void createDir(File file) {
        if (!file.getParentFile().exists()) {
            this.createDir(file.getParentFile());
        }
        if (file.exists() && !file.isDirectory()) {
            file.delete();
        }
        file.mkdir();
    }

    public static void main(String[] stringArray) throws IOException {
        final Properties properties = new Properties();
        properties.load(new FileInputStream("test"));
        final Prefs prefs = new Prefs(new PrefsEditor(new ArchiveWriter("prefs")), "VASSAL");
        Runnable runnable = new Runnable(){

            public void run() {
                new ResourceExtracter(prefs, properties, new PropertyChangeListener(this){
                    private final /* synthetic */ 5 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        System.out.println("" + propertyChangeEvent.getNewValue());
                    }
                }).install();
            }
        };
        runnable.run();
    }
}

