/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.preferences;

import VASSAL.configure.Configurer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.StringTokenizer;

public class PositionOption
extends Configurer
implements ComponentListener {
    public static String key = "BoundsOf";
    private static Point initialPos = new Point(0, 0);
    protected Window theFrame;
    protected Rectangle bounds;
    protected Rectangle defaultValue;

    public PositionOption(String string, Window window, Rectangle rectangle) {
        super(string, null, rectangle);
        PositionOption.adjustInitialOffset();
        this.theFrame = window;
        this.theFrame.pack();
        this.setFrameBounds();
        this.defaultValue = rectangle;
        this.theFrame.addComponentListener(this);
    }

    private static void adjustInitialOffset() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (PositionOption.initialPos.x >= dimension.width - 30 || PositionOption.initialPos.y >= dimension.height - 30) {
            initialPos.move(0, 0);
        } else {
            initialPos.translate(30, 30);
        }
    }

    public PositionOption(String string, Window window) {
        this(string, window, new Rectangle(initialPos, new Dimension(0, 0)));
    }

    public Object getValue() {
        return this.bounds;
    }

    public void setValue(Object object) {
        if (object instanceof Rectangle) {
            this.bounds = new Rectangle((Rectangle)object);
            if (this.theFrame != null) {
                this.setFrameBounds();
            }
        }
        super.setValue(object);
    }

    public Component getControls() {
        return null;
    }

    public void setValue(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        try {
            this.setValue(new Rectangle(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken())));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getValueString() {
        return this.bounds.x + "," + this.bounds.y + "," + this.bounds.width + "," + this.bounds.height;
    }

    private boolean isOnScreen(Point point) {
        return point.x < Toolkit.getDefaultToolkit().getScreenSize().width && point.y < Toolkit.getDefaultToolkit().getScreenSize().height;
    }

    public void componentMoved(ComponentEvent componentEvent) {
        Point point;
        if (this.theFrame.isShowing() && this.isOnScreen(point = this.theFrame.getLocationOnScreen())) {
            this.bounds.setLocation(point);
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.theFrame.isShowing()) {
            this.bounds.setSize(this.theFrame.getSize());
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    protected void setFrameBounds() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (this.bounds.width != 0 && this.bounds.height != 0) {
            ((Component)this.theFrame).setSize(new Dimension(Math.abs(this.bounds.width), Math.abs(this.bounds.height)));
        }
        ((Component)this.theFrame).setLocation(this.bounds.getLocation());
        if (this.theFrame.getLocation().x + this.theFrame.getSize().width > dimension.width) {
            ((Component)this.theFrame).setSize(dimension.width - this.theFrame.getLocation().x, this.theFrame.getSize().height);
        }
        if (this.theFrame.getLocation().y + this.theFrame.getSize().height > dimension.height) {
            ((Component)this.theFrame).setSize(this.theFrame.getSize().width, dimension.height - this.theFrame.getLocation().y);
        }
    }
}

