/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.preferences;

import VASSAL.configure.Configurer;
import VASSAL.preferences.PrefsEditor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class Prefs {
    private Hashtable options = new Hashtable();
    private Properties storedValues = new Properties();
    private PrefsEditor editor;
    private String name;

    public Prefs(PrefsEditor prefsEditor, String string) {
        this.editor = prefsEditor;
        this.name = string;
        prefsEditor.addPrefs(this);
        this.init(string);
    }

    public PrefsEditor getEditor() {
        return this.editor;
    }

    public void addOption(Configurer configurer) {
        this.addOption("General", configurer);
    }

    public void addOption(String string, Configurer configurer) {
        this.addOption(string, configurer, null);
    }

    public void addOption(String string, Configurer configurer, String string2) {
        if (configurer != null && this.options.get(configurer.getKey()) == null) {
            this.options.put(configurer.getKey(), configurer);
            String string3 = this.storedValues.getProperty(configurer.getKey());
            if (string3 != null) {
                configurer.setValue(string3);
                string2 = null;
            }
            if (string != null && configurer.getControls() != null) {
                this.editor.addOption(string, configurer, string2);
            }
        }
    }

    public void setValue(String string, Object object) {
        Configurer configurer = (Configurer)this.options.get(string);
        configurer.setValue(object);
    }

    public Configurer getOption(String string) {
        return (Configurer)this.options.get(string);
    }

    public Object getValue(String string) {
        Configurer configurer = (Configurer)this.options.get(string);
        return configurer == null ? null : configurer.getValue();
    }

    public String getStoredValue(String string) {
        return this.storedValues.getProperty(string);
    }

    public void init(String string) {
        this.name = string;
        try {
            InputStream inputStream = this.editor.getArchive().getFileStream(this.name);
            ((Hashtable)this.storedValues).clear();
            this.storedValues.load(inputStream);
            Enumeration enumeration = ((Hashtable)this.storedValues).keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = this.storedValues.getProperty(string2);
                Configurer configurer = (Configurer)this.options.get(string2);
                if (configurer == null) continue;
                configurer.setValue(string3);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void save() throws IOException {
        Object object = this.options.elements();
        while (object.hasMoreElements()) {
            Configurer configurer = (Configurer)object.nextElement();
            String string = configurer.getValueString();
            if (string != null) {
                ((Hashtable)this.storedValues).put(configurer.getKey(), string);
                continue;
            }
            ((Hashtable)this.storedValues).remove(configurer.getKey());
        }
        object = new ByteArrayOutputStream();
        this.storedValues.store((OutputStream)object, null);
        this.editor.getArchive().addFile(this.name, new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray()));
    }

    public void write() throws IOException {
        this.editor.write();
    }
}

