/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.preferences;

import VASSAL.configure.Configurer;
import VASSAL.preferences.Prefs;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.SplashScreen;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class PrefsEditor {
    private JDialog dialog;
    private Vector options = new Vector();
    private Hashtable savedValues;
    private Vector prefs;
    private JButton save;
    private JButton cancel;
    private JTabbedPane optionsTab;
    private JDialog setupDialog;
    private ArchiveWriter archive;
    private Action editAction;
    private final JPanel buttonPanel = new JPanel();

    public PrefsEditor(ArchiveWriter archiveWriter) {
        this.savedValues = new Hashtable();
        this.archive = archiveWriter;
        this.editAction = new AbstractAction("Edit Preferences"){

            public void actionPerformed(ActionEvent actionEvent) {
                PrefsEditor.this.storeValues();
                PrefsEditor.this.dialog.pack();
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                ((Component)PrefsEditor.this.dialog).setLocation(dimension.width / 2 - PrefsEditor.this.dialog.getWidth() / 2, 0);
                ((Component)PrefsEditor.this.dialog).setVisible(true);
            }
        };
        this.editAction.putValue("MnemonicKey", new Integer(80));
        this.prefs = new Vector();
        this.save = new JButton("OK");
        this.save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrefsEditor.this.save();
            }
        });
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrefsEditor.this.cancel();
            }
        });
        this.buttonPanel.add(this.save);
        this.buttonPanel.add(this.cancel);
        this.optionsTab = new JTabbedPane();
    }

    public void initDialog(Frame frame) {
        if (this.dialog == null) {
            this.dialog = new JDialog(frame, true);
            this.dialog.setTitle("Preferences");
            this.dialog.setDefaultCloseOperation(0);
            this.dialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    PrefsEditor.this.cancel();
                }
            });
            this.dialog.getContentPane().setLayout(new BoxLayout(this.dialog.getContentPane(), 1));
            this.dialog.getContentPane().add(this.optionsTab);
            this.dialog.getContentPane().add(this.buttonPanel);
        }
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void addPrefs(Prefs prefs) {
        this.prefs.addElement(prefs);
    }

    public void addOption(String string, Configurer configurer, String string2) {
        if (string2 != null) {
            if (this.setupDialog == null) {
                this.setupDialog = new JDialog((Frame)null, true);
                this.setupDialog.setTitle("Initial Setup");
                this.setupDialog.getContentPane().setLayout(new BoxLayout(this.setupDialog.getContentPane(), 1));
                this.setupDialog.setDefaultCloseOperation(0);
                this.setupDialog.addComponentListener(new ComponentAdapter(){

                    public void componentShown(ComponentEvent componentEvent) {
                        SplashScreen.sendAllToBack();
                    }
                });
            }
            this.setupDialog.getContentPane().add(new JLabel(string2));
            this.setupDialog.getContentPane().add(configurer.getControls());
            JButton jButton = new JButton("Ok");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((Component)PrefsEditor.this.setupDialog).setVisible(false);
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.add(jButton);
            this.setupDialog.getContentPane().add(jPanel);
            this.setupDialog.pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            ((Component)this.setupDialog).setLocation(dimension.width / 2 - this.setupDialog.getSize().width / 2, dimension.height / 2 - this.setupDialog.getSize().height / 2);
            ((Component)this.setupDialog).setVisible(true);
            this.setupDialog.getContentPane().removeAll();
        }
        this.addOption(string, configurer);
    }

    public void addOption(String string, Configurer configurer) {
        if (string == null) {
            string = "General";
        }
        JPanel jPanel = null;
        int n = 0;
        for (n = 0; n < this.optionsTab.getTabCount(); ++n) {
            if (!string.equals(this.optionsTab.getTitleAt(n))) continue;
            jPanel = (JPanel)this.optionsTab.getComponentAt(n);
            break;
        }
        if (n >= this.optionsTab.getTabCount()) {
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            this.optionsTab.addTab(string, jPanel);
        }
        this.options.addElement(configurer);
        Box box = Box.createHorizontalBox();
        box.add(configurer.getControls());
        box.add(Box.createHorizontalGlue());
        jPanel.add(box);
    }

    private void storeValues() {
        this.savedValues.clear();
        Enumeration enumeration = this.options.elements();
        while (enumeration.hasMoreElements()) {
            Configurer configurer = (Configurer)enumeration.nextElement();
            configurer.setFrozen(true);
            if (configurer.getValue() == null) continue;
            this.savedValues.put(configurer, configurer.getValue());
        }
    }

    public ArchiveWriter getArchive() {
        return this.archive;
    }

    protected void cancel() {
        Enumeration enumeration = this.options.elements();
        while (enumeration.hasMoreElements()) {
            Configurer configurer = (Configurer)enumeration.nextElement();
            configurer.setValue(this.savedValues.get(configurer));
            configurer.setFrozen(false);
        }
        ((Component)this.dialog).setVisible(false);
    }

    protected void save() {
        Enumeration enumeration = this.options.elements();
        while (enumeration.hasMoreElements()) {
            Configurer configurer = (Configurer)enumeration.nextElement();
            configurer.fireUpdate();
            configurer.setFrozen(false);
        }
        try {
            this.write();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.dialog.getOwner(), "Unable to save preferences.\n", "Save error", 0);
        }
        ((Component)this.dialog).setVisible(false);
    }

    public Action getEditAction() {
        return this.editAction;
    }

    public void write() throws IOException {
        Enumeration enumeration = this.prefs.elements();
        while (enumeration.hasMoreElements()) {
            ((Prefs)enumeration.nextElement()).save();
        }
        this.archive.write();
    }
}

