/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.GameModule;
import VASSAL.build.module.Documentation;
import VASSAL.tools.DataArchive;
import VASSAL.tools.FileChooser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ArchiveWriter
extends DataArchive {
    private Hashtable images = new Hashtable();
    private Hashtable sounds = new Hashtable();
    private Hashtable files = new Hashtable();
    private String archiveName;

    public ArchiveWriter(String string) {
        this.archiveName = string;
        if (this.archiveName == null) {
            this.archive = null;
        } else {
            try {
                this.archive = new ZipFile(this.archiveName);
            }
            catch (IOException iOException) {
                this.archive = null;
            }
        }
    }

    public ArchiveWriter(ZipFile zipFile) {
        this.archive = zipFile;
        this.archiveName = zipFile.getName();
    }

    public void addImage(String string, String string2) {
        this.unCacheImage(string2);
        this.images.put("images/" + string2, string);
        this.imageNames = null;
    }

    public void addImage(String string, byte[] byArray) {
        this.unCacheImage(string);
        this.images.put("images/" + string, byArray);
        this.imageNames = null;
    }

    public void addSound(String string, String string2) {
        this.sounds.put("sounds/" + string2, string);
    }

    public boolean isImageAdded(String string) {
        return this.images.containsKey(string);
    }

    public void removeImage(String string) {
        this.unCacheImage(string);
        this.images.remove("images/" + string);
    }

    public void addFile(String string, String string2) {
        this.files.put(string2, string);
    }

    public void addFile(String string, InputStream inputStream) {
        try {
            this.files.put(string, DataArchive.getBytes(inputStream));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void addFile(String string, byte[] byArray) {
        this.files.put(string, byArray);
    }

    public InputStream getFileStream(String string) throws IOException {
        InputStream inputStream = this.getAddedStream(this.images, string);
        if (inputStream == null) {
            inputStream = this.getAddedStream(this.files, string);
        }
        if (inputStream == null) {
            inputStream = this.getAddedStream(this.sounds, string);
        }
        if (inputStream == null) {
            if (this.archive != null) {
                inputStream = super.getFileStream(string);
            } else {
                throw new IOException(string + " not found");
            }
        }
        return inputStream;
    }

    private InputStream getAddedStream(Hashtable hashtable, String string) throws IOException {
        InputStream inputStream = null;
        Object v = hashtable.get(string);
        if (v instanceof String) {
            inputStream = new FileInputStream((String)v);
        } else if (v instanceof byte[]) {
            inputStream = new ByteArrayInputStream((byte[])v);
        }
        return inputStream;
    }

    public void saveAs() throws IOException {
        this.archiveName = null;
        this.write();
    }

    public void write() throws IOException {
        Object object;
        Object object2;
        Object object3;
        if (this.archiveName == null) {
            object3 = FileChooser.createFileChooser(GameModule.getGameModule().getFrame());
            ((FileChooser)object3).setCurrentDirectory(Documentation.getDocumentationBaseDir());
            if (((FileChooser)object3).showSaveDialog() != 0) {
                return;
            }
            this.archiveName = ((FileChooser)object3).getSelectedFile().getPath();
        }
        object3 = (object3 = new File(this.archiveName).getParent()) == null ? "temp" : (String)object3 + File.separator + "temp";
        int n = 1;
        while (new File((String)object3 + n + ".zip").exists()) {
            ++n;
        }
        object3 = (String)object3 + n + ".zip";
        byte[] byArray = new byte[1024];
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream((String)object3));
        if (this.archive != null) {
            object2 = null;
            object = new ZipInputStream(new FileInputStream(this.archive.getName()));
            while ((object2 = ((ZipInputStream)object).getNextEntry()) != null) {
                int n2;
                if (this.images.containsKey(((ZipEntry)object2).getName()) || this.sounds.containsKey(((ZipEntry)object2).getName()) || this.files.containsKey(((ZipEntry)object2).getName())) continue;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n2 = ((ZipInputStream)object).read(byArray, 0, 1024)) >= 0) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                }
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                ZipEntry zipEntry = new ZipEntry(((ZipEntry)object2).getName());
                zipEntry.setMethod(((ZipEntry)object2).getMethod());
                if (zipEntry.getMethod() == 0) {
                    zipEntry.setSize(byArray2.length);
                    CRC32 cRC32 = new CRC32();
                    cRC32.update(byArray2);
                    zipEntry.setCrc(cRC32.getValue());
                }
                zipOutputStream.putNextEntry(zipEntry);
                zipOutputStream.write(byArray2, 0, byArray2.length);
            }
            ((ZipInputStream)object).close();
            this.archive.close();
        }
        ArchiveWriter.writeEntries(this.images, 0, zipOutputStream);
        ArchiveWriter.writeEntries(this.sounds, 0, zipOutputStream);
        ArchiveWriter.writeEntries(this.files, 8, zipOutputStream);
        zipOutputStream.close();
        object2 = new File(this.archiveName);
        if (((File)object2).exists() && !((File)object2).delete()) {
            throw new IOException("Unable to overwrite " + this.archiveName + "\nData stored in " + (String)object3);
        }
        object = new File((String)object3);
        if (!((File)object).renameTo((File)object2)) {
            throw new IOException("Unable to write to " + this.archiveName + "\nData stored in " + (String)object3);
        }
        this.archive = new ZipFile(this.archiveName);
    }

    private static void writeEntries(Hashtable hashtable, int n, ZipOutputStream zipOutputStream) throws IOException {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            byte[] byArray;
            Object object;
            String string = (String)enumeration.nextElement();
            Object v = hashtable.get(string);
            if (v instanceof String) {
                object = (String)v;
                byArray = DataArchive.getBytes(new FileInputStream((String)object));
            } else if (v instanceof byte[]) {
                byArray = (byte[])v;
            } else {
                System.err.println("Could not write entry " + string + " = " + v);
                break;
            }
            ZipEntry zipEntry = new ZipEntry(string);
            zipEntry.setMethod(n);
            if (n == 0) {
                zipEntry.setSize(byArray.length);
                object = new CRC32();
                object.update(byArray);
                zipEntry.setCrc(((CRC32)object).getValue());
            }
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(byArray);
        }
    }

    protected void listImageNames(Collection collection) {
        super.listImageNames(collection);
        Enumeration enumeration = this.images.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("images/")) continue;
            collection.add(string.substring("images/".length()));
        }
    }
}

