/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.ImageSource;
import VASSAL.tools.ImprovedAveragingScaleFilter;
import java.applet.AudioClip;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.swing.ImageIcon;
import sun.applet.AppletAudioClip;

public class DataArchive
extends SecureClassLoader {
    protected ZipFile archive = null;
    protected List extensions = new ArrayList();
    private HashMap imageCache = new HashMap();
    private HashMap soundCache = new HashMap();
    private HashMap scaledImageCache = new HashMap();
    private HashMap imageSources = new HashMap();
    protected String[] imageNames;
    public static final String IMAGE_DIR = "images/";
    public static final String SOUNDS_DIR = "sounds/";
    private BooleanConfigurer smoothPrefs;
    private CodeSource cs;
    private static final Image NULL_IMAGE = new BufferedImage(1, 1, 6);
    static /* synthetic */ Class class$VASSAL$tools$DataArchive;

    protected DataArchive() {
        super((class$VASSAL$tools$DataArchive == null ? (class$VASSAL$tools$DataArchive = DataArchive.class$("VASSAL.tools.DataArchive")) : class$VASSAL$tools$DataArchive).getClassLoader());
    }

    public DataArchive(String string) throws IOException {
        this();
        this.archive = new ZipFile(string);
    }

    public String getName() {
        return this.archive == null ? "data archive" : this.archive.getName();
    }

    public ZipFile getArchive() {
        return this.archive;
    }

    public static Image findImage(File file, String string) throws IOException {
        return DataArchive.getImage(DataArchive.getFileStream(file, string));
    }

    public static InputStream getFileStream(File file, String string) throws IOException {
        try {
            ZipFile zipFile = new ZipFile(file);
            return zipFile.getInputStream(zipFile.getEntry(string));
        }
        catch (Exception exception) {
            throw new IOException("Couldn't locate " + string + " in " + file.getName() + ": " + exception.getMessage());
        }
    }

    public static Image findImage(File file, String string, String string2) throws IOException {
        if (new File(file, string).exists()) {
            return DataArchive.getImage(DataArchive.getFileStream(file, string, string2));
        }
        if (new File(file, string2).exists()) {
            return Toolkit.getDefaultToolkit().getImage(file.getPath() + File.separatorChar + string2);
        }
        throw new IOException("Image " + string2 + " not found in " + file + File.separator + string);
    }

    public Image getCachedImage(String string) throws IOException {
        String string2 = IMAGE_DIR + string;
        String string3 = string2 + ".gif";
        Image image = (Image)this.imageCache.get(string2);
        if (image != null) {
            return image;
        }
        image = (Image)this.imageCache.get(string3);
        if (image != null) {
            return image;
        }
        ImageSource imageSource = (ImageSource)this.imageSources.get(string);
        image = imageSource != null ? imageSource.getImage() : this.getImage(string);
        this.imageCache.put(string2, image);
        return image;
    }

    public AudioClip getCachedAudioClip(String string) throws IOException {
        String string2 = SOUNDS_DIR + string;
        AudioClip audioClip = (AudioClip)this.soundCache.get(string2);
        if (audioClip == null) {
            audioClip = new AppletAudioClip(DataArchive.getBytes(this.getFileStream(string2)));
            this.soundCache.put(string2, audioClip);
        }
        return audioClip;
    }

    public Image getScaledImage(Image image, double d) {
        return this.getScaledImage(image, d, false, true);
    }

    public Image getScaledImage(Image image, double d, boolean bl, boolean bl2) {
        if (image == null) {
            return null;
        }
        Dimension dimension = DataArchive.getImageBounds(image).getSize();
        dimension.width = (int)((double)dimension.width * d);
        dimension.height = (int)((double)dimension.height * d);
        if (dimension.width == 0 || dimension.height == 0) {
            return NULL_IMAGE;
        }
        ScaledCacheKey scaledCacheKey = new ScaledCacheKey(image, dimension, bl);
        Image image2 = (Image)this.scaledImageCache.get(scaledCacheKey);
        if (image2 == null) {
            image2 = this.createScaledInstance(image, dimension, bl, bl2);
            new ImageIcon(image2);
            this.scaledImageCache.put(scaledCacheKey, image2);
        }
        return image2;
    }

    protected Image createScaledInstance(Image image, Dimension dimension, boolean bl, boolean bl2) {
        Dimension dimension2 = DataArchive.getImageBounds(image).getSize();
        if (dimension2.equals(dimension) && !bl) {
            return image;
        }
        if (this.smoothPrefs == null) {
            this.smoothPrefs = (BooleanConfigurer)GameModule.getGameModule().getPrefs().getOption("scalerAlgorithm");
            if (this.smoothPrefs == null) {
                this.smoothPrefs = new BooleanConfigurer(null, null, Boolean.TRUE);
            }
            this.smoothPrefs.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    DataArchive.this.clearScaledImageCache();
                }
            });
        }
        boolean bl3 = Boolean.TRUE.equals(this.smoothPrefs.getValue());
        if (bl) {
            BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 6);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            if (bl3) {
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            }
            double d = (double)dimension.width / (double)dimension2.width;
            AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.PI, (double)dimension.width * 0.5, (double)dimension.height * 0.5);
            affineTransform.scale(d, d);
            graphics2D.drawImage(image, affineTransform, null);
            return bufferedImage;
        }
        if (bl3 && bl2) {
            return this.improvedScaling(image, dimension.width, dimension.height);
        }
        return image.getScaledInstance(dimension.width, dimension.height, bl3 ? 16 : 1);
    }

    public static Rectangle getImageBounds(Image image) {
        ImageIcon imageIcon = new ImageIcon(image);
        return new Rectangle(-imageIcon.getIconWidth() / 2, -imageIcon.getIconHeight() / 2, imageIcon.getIconWidth(), imageIcon.getIconHeight());
    }

    public Image improvedScaling(Image image, int n, int n2) {
        ImprovedAveragingScaleFilter improvedAveragingScaleFilter = new ImprovedAveragingScaleFilter(image.getWidth(null), image.getHeight(null), n, n2);
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), improvedAveragingScaleFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    public Dimension getImageSize(String string) throws IOException {
        String string2 = IMAGE_DIR + string;
        String string3 = string2 + ".gif";
        String string4 = string.substring(string.lastIndexOf(46) + 1);
        ImageReader imageReader = ImageIO.getImageReadersBySuffix(string4).next();
        try {
            imageReader.setInput(new MemoryCacheImageInputStream(this.getFileStream(string2)));
        }
        catch (IOException iOException) {
            imageReader.setInput(new MemoryCacheImageInputStream(this.getFileStream(string3)));
        }
        return new Dimension(imageReader.getWidth(0), imageReader.getHeight(0));
    }

    public void unCacheImage(String string) {
        this.imageCache.remove(IMAGE_DIR + string);
    }

    public void unCacheImage(Image image) {
        ScaledCacheKey scaledCacheKey;
        ArrayList<ScaledCacheKey> arrayList = new ArrayList<ScaledCacheKey>();
        Iterator<Object> iterator = this.scaledImageCache.keySet().iterator();
        while (iterator.hasNext()) {
            scaledCacheKey = (ScaledCacheKey)iterator.next();
            if (!image.equals(scaledCacheKey.base)) continue;
            arrayList.add(scaledCacheKey);
        }
        iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            scaledCacheKey = (ScaledCacheKey)iterator.next();
            this.scaledImageCache.remove(scaledCacheKey);
        }
    }

    public void clearScaledImageCache() {
        this.scaledImageCache.clear();
        Iterator iterator = this.extensions.iterator();
        while (iterator.hasNext()) {
            DataArchive dataArchive = (DataArchive)iterator.next();
            dataArchive.clearScaledImageCache();
        }
    }

    public Image getImage(String string) throws IOException {
        String string2 = IMAGE_DIR + string;
        String string3 = string2 + ".gif";
        Image image = null;
        try {
            image = DataArchive.getImage(this.getFileStream(string2));
        }
        catch (IOException iOException) {
            image = DataArchive.getImage(this.getFileStream(string3));
        }
        return image;
    }

    public static Image getImage(InputStream inputStream) throws IOException {
        return Toolkit.getDefaultToolkit().createImage(DataArchive.getBytes(inputStream));
    }

    public boolean addImageSource(String string, ImageSource imageSource) {
        if (!this.imageSources.containsKey(string)) {
            this.imageSources.put(string, imageSource);
            this.imageNames = null;
            return true;
        }
        return false;
    }

    public void removeImageSource(String string) {
        this.imageSources.remove(string);
        this.imageNames = null;
        this.unCacheImage(string);
    }

    public static byte[] getBytes(InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        int n = bufferedInputStream.available();
        int n2 = 0;
        byte[] byArray = null;
        byte[] byArray2 = new byte[n];
        while ((n2 = bufferedInputStream.read(byArray2, 0, byArray2.length)) > 0) {
            if (byArray == null) {
                byArray = new byte[n2];
                System.arraycopy(byArray2, 0, byArray, 0, n2);
                continue;
            }
            byte[] byArray3 = byArray;
            byArray = new byte[byArray3.length + n2];
            System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
            System.arraycopy(byArray2, 0, byArray, byArray3.length, n2);
        }
        return byArray != null ? byArray : new byte[]{};
    }

    public InputStream getFileStream(String string) throws IOException {
        InputStream inputStream = null;
        ZipEntry zipEntry = this.archive.getEntry(string);
        inputStream = zipEntry != null ? this.archive.getInputStream(zipEntry) : this.getFileStreamFromExtension(string);
        if (inputStream == null) {
            throw new IOException("'" + string + "' not found in " + this.archive.getName());
        }
        return inputStream;
    }

    protected InputStream getFileStreamFromExtension(String string) {
        InputStream inputStream = null;
        for (int i = 0; i < this.extensions.size() && inputStream == null; ++i) {
            DataArchive dataArchive = (DataArchive)this.extensions.get(i);
            try {
                inputStream = dataArchive.getFileStream(string);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return inputStream;
    }

    public URL getURL(String string) throws IOException {
        if (this.archive == null) {
            throw new IOException("Must save before accessing contents");
        }
        URL uRL = null;
        ZipEntry zipEntry = this.archive.getEntry(string);
        if (zipEntry != null) {
            String string2 = HelpFile.toURL(new File(this.archive.getName())).toString();
            uRL = new URL("jar:" + string2 + "!/" + string);
        } else {
            uRL = this.getURLFromExtension(string);
        }
        if (uRL == null) {
            throw new IOException("'" + string + "' not found in " + this.archive.getName());
        }
        return uRL;
    }

    protected URL getURLFromExtension(String string) {
        URL uRL = null;
        for (int i = 0; i < this.extensions.size() && uRL == null; ++i) {
            DataArchive dataArchive = (DataArchive)this.extensions.get(i);
            try {
                uRL = dataArchive.getURL(string);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return uRL;
    }

    public void addExtension(DataArchive dataArchive) {
        this.extensions.add(dataArchive);
    }

    public ArchiveWriter getWriter() {
        ArchiveWriter archiveWriter = null;
        if (this instanceof ArchiveWriter) {
            archiveWriter = (ArchiveWriter)this;
        } else {
            Iterator iterator = this.extensions.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof ArchiveWriter)) continue;
                archiveWriter = (ArchiveWriter)e;
                break;
            }
        }
        return archiveWriter;
    }

    public static InputStream getFileStream(File file, String string, String string2) {
        try {
            if (new File(file, string).exists()) {
                ZipFile zipFile = new ZipFile(new File(file, string));
                return zipFile.getInputStream(zipFile.getEntry(string2));
            }
            return new FileInputStream(new File(file, string2));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            clazz = this.findLoadedClass(string);
        }
        if (clazz == null) {
            return this.findClass(string);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        permissionCollection.add(new AllPermission());
        return permissionCollection;
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        if (this.cs == null) {
            this.cs = new CodeSource((URL)null, (Certificate[])null);
        }
        try {
            String string2 = string.replace('.', '/');
            InputStream inputStream = this.getFileStream(string2 + ".class");
            byte[] byArray = DataArchive.getBytes(inputStream);
            return this.defineClass(string, byArray, 0, byArray.length, this.cs);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException("Unable to load " + string + "\n" + iOException.getMessage());
        }
    }

    public String[] getImageNames() {
        if (this.isNameCacheStale()) {
            HashSet hashSet = new HashSet();
            this.listImageNames(hashSet);
            ArrayList arrayList = new ArrayList(hashSet);
            Collections.sort(arrayList, String.CASE_INSENSITIVE_ORDER);
            this.imageNames = arrayList.toArray(new String[arrayList.size()]);
        }
        return this.imageNames;
    }

    protected boolean isNameCacheStale() {
        boolean bl = this.imageNames == null;
        Iterator iterator = this.extensions.iterator();
        while (iterator.hasNext() && !bl) {
            bl = ((DataArchive)iterator.next()).imageNames == null;
        }
        return bl;
    }

    protected void listImageNames(Collection collection) {
        Object object = this.imageSources.keySet().iterator();
        while (object.hasNext()) {
            collection.add(object.next());
        }
        if (this.archive != null) {
            try {
                object = new ZipInputStream(new FileInputStream(this.archive.getName()));
                ZipEntry zipEntry = null;
                while ((zipEntry = ((ZipInputStream)object).getNextEntry()) != null) {
                    if (!zipEntry.getName().startsWith(IMAGE_DIR)) continue;
                    collection.add(zipEntry.getName().substring(IMAGE_DIR.length()));
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        object = this.extensions.iterator();
        while (object.hasNext()) {
            ((DataArchive)object.next()).listImageNames(collection);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ScaledCacheKey {
        private Image base;
        private Dimension bounds;
        private boolean reversed;

        public ScaledCacheKey(Image image, Dimension dimension, boolean bl) {
            this.bounds = dimension;
            this.base = image;
            this.reversed = bl;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ScaledCacheKey)) {
                return false;
            }
            ScaledCacheKey scaledCacheKey = (ScaledCacheKey)object;
            if (this.reversed != scaledCacheKey.reversed) {
                return false;
            }
            if (!this.base.equals(scaledCacheKey.base)) {
                return false;
            }
            return this.bounds.equals(scaledCacheKey.bounds);
        }

        public int hashCode() {
            int n = this.base.hashCode();
            n = 29 * n + this.bounds.hashCode();
            n = 29 * n + (this.reversed ? 1 : 0);
            return n;
        }
    }
}

