/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.GameModule;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ErrorLog {
    private static boolean disabled = false;

    public void handle(Throwable throwable) {
        String string = System.getProperty("stderr");
        if (!disabled && string != null) {
            String string2 = throwable.getClass().getName().substring(throwable.getClass().getName().lastIndexOf(".") + 1);
            String string3 = throwable.getMessage();
            string3 = string3 == null || string3.length() == 0 ? string2 : string2 + "\n" + string3;
            JButton jButton = new JButton("Ok");
            JButton jButton2 = new JButton("Don't show this dialog again");
            String string4 = "An untrapped error has occurred.\n" + string3 + "\n" + "Please send a report to support@vassalengine.org and attach the log file.\n" + string;
            if (throwable instanceof OutOfMemoryError) {
                string4 = "The application has run out of memory.\nTo decrease memory usage, try reducing the number of colors in your display.";
            }
            final JOptionPane jOptionPane = new JOptionPane(string4, -1, 0, UIManager.getIcon("OptionPane.errorIcon"), new Object[]{jButton, jButton2}, jButton);
            JFrame jFrame = GameModule.getGameModule() == null ? null : GameModule.getGameModule().getFrame();
            final JDialog jDialog = jOptionPane.createDialog(jFrame, "Error");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jOptionPane.setValue(Boolean.FALSE);
                    jDialog.dispose();
                }
            });
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jOptionPane.setValue(Boolean.TRUE);
                    jDialog.dispose();
                }
            });
            Runnable runnable = new Runnable(){

                public void run() {
                    ((Component)jDialog).setVisible(true);
                    disabled = Boolean.TRUE.equals(jOptionPane.getValue());
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
        throwable.printStackTrace();
    }

    public static void main(String[] stringArray) {
        ErrorLog errorLog = new ErrorLog();
        while (!disabled) {
            errorLog.handle(new RuntimeException("Warning!!!"));
        }
    }

    public static class Group
    extends ThreadGroup {
        private ErrorLog handler = new ErrorLog();

        public Group() {
            super("Main Thread");
        }

        public void uncaughtException(Thread thread, Throwable throwable) {
            this.handler.handle(throwable);
        }
    }
}

