/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.FileFilter;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public abstract class FileChooser {
    protected Component parent;
    public static final int APPROVE_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    public static final int ERROR_OPTION = -1;
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int FILES_AND_DIRECTORIES = 2;
    static /* synthetic */ Class class$java$awt$Frame;

    private FileChooser(Component component) {
        this.parent = component;
    }

    public static FileChooser createFileChooser(Component component) {
        String string = System.getProperty("os.name");
        if (string != null && (string.startsWith("Windows") || string.startsWith("Mac OS"))) {
            return new NativeFileChooser(component);
        }
        return new SwingFileChooser(component);
    }

    public abstract File getCurrentDirectory();

    public abstract void setCurrentDirectory(File var1);

    public abstract void rescanCurrentDirectory();

    public abstract File getSelectedFile();

    public abstract void setSelectedFile(File var1);

    public abstract int getFileSelectionMode();

    public abstract void setFileSelectionMode(int var1);

    public abstract String getDialogTitle();

    public abstract void setDialogTitle(String var1);

    public abstract int showOpenDialog(Component var1);

    public abstract int showSaveDialog(Component var1);

    public abstract FileFilter getFileFilter();

    public abstract void setFileFilter(FileFilter var1);

    public abstract void addChoosableFileFilter(FileFilter var1);

    public abstract boolean removeChoosableFileFilter(FileFilter var1);

    public abstract void resetChoosableFileFilters();

    public void selectDotSavFile() {
        int n;
        String string;
        File file = this.getSelectedFile();
        if (file != null && (string = file.getPath()) != null && (n = string.lastIndexOf(46)) > 0) {
            string = string.substring(0, n) + ".sav";
            this.setSelectedFile(new File(string));
        }
    }

    public int showOpenDialog() {
        return this.showOpenDialog(this.parent);
    }

    public int showSaveDialog() {
        return this.showSaveDialog(this.parent);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class NativeFileChooser
    extends FileChooser {
        private File cur;
        private String title;
        private FileFilter filter;

        public NativeFileChooser(Component component) {
            super(component);
        }

        public File getCurrentDirectory() {
            return this.cur == null ? null : this.cur.getParentFile();
        }

        public void setCurrentDirectory(File file) {
            this.cur = file;
        }

        public void rescanCurrentDirectory() {
        }

        public File getSelectedFile() {
            return this.cur;
        }

        public void setSelectedFile(File file) {
            this.cur = file;
        }

        public int getFileSelectionMode() {
            return 0;
        }

        public void setFileSelectionMode(int n) {
        }

        public String getDialogTitle() {
            return this.title;
        }

        public void setDialogTitle(String string) {
            this.title = string;
        }

        protected FileDialog awt_file_dialog_init(Component component) {
            Frame frame = component instanceof Frame ? (Frame)component : (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = FileChooser.class$("java.awt.Frame")) : class$java$awt$Frame, component);
            FileDialog fileDialog = new FileDialog(frame, this.title);
            fileDialog.setModal(true);
            fileDialog.setFilenameFilter(this.filter);
            if (this.cur != null) {
                if (this.cur.isDirectory()) {
                    fileDialog.setDirectory(this.cur.getPath());
                } else {
                    fileDialog.setDirectory(this.cur.getParent());
                    fileDialog.setFile(this.cur.getName());
                }
            }
            return fileDialog;
        }

        public int showOpenDialog(Component component) {
            FileDialog fileDialog = this.awt_file_dialog_init(component);
            fileDialog.setMode(0);
            ((Component)fileDialog).setVisible(true);
            if (fileDialog.getFile() != null) {
                this.cur = new File(fileDialog.getDirectory(), fileDialog.getFile());
                return 0;
            }
            return 1;
        }

        public int showSaveDialog(Component component) {
            FileDialog fileDialog = this.awt_file_dialog_init(component);
            fileDialog.setMode(1);
            ((Component)fileDialog).setVisible(true);
            if (fileDialog.getFile() != null) {
                this.cur = new File(fileDialog.getDirectory(), fileDialog.getFile());
                return 0;
            }
            return 1;
        }

        public FileFilter getFileFilter() {
            return this.filter;
        }

        public void setFileFilter(FileFilter fileFilter) {
            this.filter = fileFilter;
        }

        public void addChoosableFileFilter(FileFilter fileFilter) {
        }

        public boolean removeChoosableFileFilter(FileFilter fileFilter) {
            return false;
        }

        public void resetChoosableFileFilters() {
        }
    }

    private static class SwingFileChooser
    extends FileChooser {
        private JFileChooser fc = new JFileChooser();

        public SwingFileChooser(Component component) {
            super(component);
        }

        public File getCurrentDirectory() {
            return this.fc.getCurrentDirectory();
        }

        public void setCurrentDirectory(File file) {
            this.fc.setCurrentDirectory(file);
        }

        public void rescanCurrentDirectory() {
            this.fc.rescanCurrentDirectory();
        }

        public File getSelectedFile() {
            return this.fc.getSelectedFile();
        }

        public void setSelectedFile(File file) {
            this.fc.setSelectedFile(file);
        }

        public int getFileSelectionMode() {
            return this.fc.getFileSelectionMode();
        }

        public void setFileSelectionMode(int n) {
            this.fc.setFileSelectionMode(n);
        }

        public String getDialogTitle() {
            return this.fc.getDialogTitle();
        }

        public void setDialogTitle(String string) {
            this.fc.setDialogTitle(string);
        }

        public int showOpenDialog(Component component) {
            return this.fc.showOpenDialog(component);
        }

        public int showSaveDialog(Component component) {
            int n = this.fc.showSaveDialog(component);
            if (n == 0 && this.getSelectedFile().exists() && 1 == JOptionPane.showConfirmDialog(component, "Overwrite " + this.getSelectedFile().getName() + "?", "File Exists", 0)) {
                n = 1;
            }
            return n;
        }

        public FileFilter getFileFilter() {
            javax.swing.filechooser.FileFilter fileFilter = this.fc.getFileFilter();
            return fileFilter instanceof FileFilter ? (FileFilter)fileFilter : null;
        }

        public void setFileFilter(FileFilter fileFilter) {
            this.fc.setFileFilter(fileFilter);
        }

        public void addChoosableFileFilter(FileFilter fileFilter) {
            this.fc.addChoosableFileFilter(fileFilter);
        }

        public boolean removeChoosableFileFilter(FileFilter fileFilter) {
            return this.fc.removeChoosableFileFilter(fileFilter);
        }

        public void resetChoosableFileFilters() {
            this.fc.resetChoosableFileFilters();
        }
    }
}

