/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.SequenceEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;

public class PropertiesEncoder {
    private Properties prop;
    private String stringValue;

    public PropertiesEncoder(Properties properties) {
        this.prop = properties;
        this.stringValue = this.encode(properties);
    }

    public PropertiesEncoder(String string) throws IOException {
        this.stringValue = string;
        this.prop = this.decode(string);
    }

    private String encode(Properties properties) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            properties.store(byteArrayOutputStream, null);
            String string = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r", false);
            SequenceEncoder sequenceEncoder = new SequenceEncoder('|');
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.startsWith("#")) continue;
                sequenceEncoder.append(string2);
            }
            return sequenceEncoder.getValue();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "";
        }
    }

    private Properties decode(String string) throws IOException {
        Properties properties = new Properties();
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '|');
        StringBuffer stringBuffer = new StringBuffer();
        while (decoder.hasMoreTokens()) {
            stringBuffer.append(decoder.nextToken());
            if (!decoder.hasMoreTokens()) continue;
            stringBuffer.append('\n');
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes("UTF-8"));
        properties.load(byteArrayInputStream);
        return properties;
    }

    public Properties getProperties() {
        return this.prop;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public String toString() {
        return this.stringValue;
    }
}

