/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class RotateFilter
extends ImageFilter {
    private double angle;
    private double cos;
    private double sin;
    private Rectangle rotatedSpace;
    private Rectangle originalSpace;
    private ColorModel defaultRGBModel;
    private int[] inPixels;
    private int[] outPixels;

    public RotateFilter(double d) {
        this.angle = d * (Math.PI / 180);
        this.cos = Math.cos(this.angle);
        this.sin = Math.sin(this.angle);
        this.defaultRGBModel = ColorModel.getRGBdefault();
    }

    private void transform(int n, int n2, double[] dArray) {
        dArray[0] = (double)n * this.cos + (double)n2 * this.sin;
        dArray[1] = (double)n2 * this.cos - (double)n * this.sin;
    }

    private void transformBack(int n, int n2, double[] dArray) {
        dArray[0] = (double)n * this.cos - (double)n2 * this.sin;
        dArray[1] = (double)n2 * this.cos + (double)n * this.sin;
    }

    public void transformSpace(Rectangle rectangle) {
        double[] dArray = new double[2];
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        double d4 = Double.MIN_VALUE;
        int n = rectangle.width;
        int n2 = rectangle.height;
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        for (int i = 0; i < 4; ++i) {
            switch (i) {
                case 0: {
                    this.transform(n3 + 0, n4 + 0, dArray);
                    break;
                }
                case 1: {
                    this.transform(n3 + n - 1, n4 + 0, dArray);
                    break;
                }
                case 2: {
                    this.transform(n3 + 0, n4 + n2 - 1, dArray);
                    break;
                }
                case 3: {
                    this.transform(n3 + n - 1, n4 + n2 - 1, dArray);
                }
            }
            d = Math.min(d, dArray[0]);
            d2 = Math.min(d2, dArray[1]);
            d3 = Math.max(d3, dArray[0]);
            d4 = Math.max(d4, dArray[1]);
        }
        rectangle.x = (int)Math.round(d);
        rectangle.y = (int)Math.round(d2);
        rectangle.width = (int)Math.round(d3) - rectangle.x + 1;
        rectangle.height = (int)Math.round(d4) - rectangle.y + 1;
    }

    public void setDimensions(int n, int n2) {
        this.originalSpace = new Rectangle(0, 0, n, n2);
        this.rotatedSpace = new Rectangle(0, 0, n, n2);
        this.transformSpace(this.rotatedSpace);
        this.inPixels = new int[this.originalSpace.width * this.originalSpace.height];
        this.consumer.setDimensions(this.rotatedSpace.width, this.rotatedSpace.height);
    }

    public void setColorModel(ColorModel colorModel) {
        this.consumer.setColorModel(this.defaultRGBModel);
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int n7 = n2 * this.originalSpace.width + n;
        int n8 = n5;
        int n9 = n6 - n3;
        int n10 = this.originalSpace.width - n3;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                this.inPixels[n7++] = colorModel.getRGB(byArray[n8++] & 0xFF);
            }
            n8 += n9;
            n7 += n10;
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        int n7 = n2 * this.originalSpace.width + n;
        int n8 = n5;
        int n9 = n6 - n3;
        int n10 = this.originalSpace.width - n3;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                this.inPixels[n7++] = colorModel.getRGB(nArray[n8++]);
            }
            n8 += n9;
            n7 += n10;
        }
    }

    public void imageComplete(int n) {
        if (n == 1 || n == 4) {
            this.consumer.imageComplete(n);
            return;
        }
        double[] dArray = new double[2];
        int n2 = this.originalSpace.width;
        int n3 = this.originalSpace.height;
        int n4 = this.rotatedSpace.width;
        int n5 = this.rotatedSpace.height;
        this.outPixels = new int[n4 * n5];
        int n6 = this.rotatedSpace.x;
        int n7 = this.rotatedSpace.y;
        int n8 = 0;
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n4; ++j) {
                this.transformBack(n6 + j, n7 + i, dArray);
                int n9 = (int)Math.round(dArray[0]);
                int n10 = (int)Math.round(dArray[1]);
                this.outPixels[n8++] = n9 < 0 || n9 >= n2 || n10 < 0 || n10 >= n3 ? 0 : this.inPixels[n10 * n2 + n9];
            }
        }
        this.consumer.setPixels(0, 0, n4, n5, this.defaultRGBModel, this.outPixels, 0, n4);
        this.consumer.imageComplete(n);
    }

    public static void main(String[] stringArray) {
        final Image image = Toolkit.getDefaultToolkit().getImage("ASL/images/Climb1d.gif");
        RotateFilter rotateFilter = new RotateFilter(-60.0);
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), rotateFilter);
        final Image image2 = new JLabel().createImage(filteredImageSource);
        JFrame jFrame = new JFrame(){

            public void paint(Graphics graphics) {
                graphics.setColor(Color.blue);
                graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
                graphics.drawImage(image2, 100, 100, this);
                graphics.drawImage(image, 0, 0, this);
                graphics.drawImage(image, 100 + image.getWidth(this), image.getHeight(this), 100, 0, 0, 0, 0 + image.getWidth(this), image.getHeight(this), this);
            }
        };
        ((Component)jFrame).setSize(300, 300);
        ((Component)jFrame).setVisible(true);
    }
}

