/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.widget.PieceSlot;
import VASSAL.command.Command;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceCloner;
import VASSAL.counters.Replace;
import VASSAL.counters.Stack;
import VASSAL.tools.ComponentPathBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class SavedGameUpdater {
    public Properties getPieceSlotsMap() {
        Properties properties = new Properties();
        ArrayList arrayList = new ArrayList();
        this.findPieceSlots(arrayList, properties);
        return properties;
    }

    public void updateSavedGame(Properties properties, File file) throws IOException {
        GameModule.getGameModule().getGameState().setup(false);
        GameModule.getGameModule().getGameState().loadGame(file);
        while (!GameModule.getGameModule().getGameState().isGameStarted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Enumeration enumeration = GameModule.getGameModule().getGameState().getPieces();
        while (enumeration.hasMoreElements()) {
            GamePiece gamePiece = (GamePiece)enumeration.nextElement();
            if (gamePiece instanceof Stack) continue;
            String string = properties.getProperty(gamePiece.getType());
            if (string != null) {
                Configurable[] configurableArray = null;
                try {
                    PieceSlot pieceSlot;
                    configurableArray = ComponentPathBuilder.getInstance().getPath(string);
                    if (configurableArray == null || configurableArray.length <= 0 || !(configurableArray[configurableArray.length - 1] instanceof PieceSlot) || (pieceSlot = (PieceSlot)configurableArray[configurableArray.length - 1]).getPiece().getType().equals(gamePiece.getType())) continue;
                    ReplaceTrait replaceTrait = new ReplaceTrait(gamePiece, pieceSlot.getPiece());
                    replaceTrait.replacePiece();
                }
                catch (ComponentPathBuilder.PathFormatException pathFormatException) {
                    System.err.println("Unable to replace " + gamePiece.getName() + ": " + pathFormatException.getMessage());
                }
                continue;
            }
            System.err.println("Unable to find slot for " + gamePiece.getName());
            System.out.println(gamePiece.getType());
        }
        GameModule.getGameModule().getGameState().saveGame(file);
    }

    protected void findPieceSlots(List list, Properties properties) {
        GameModule gameModule;
        GameModule gameModule2 = gameModule = list.size() == 0 ? GameModule.getGameModule() : list.get(list.size() - 1);
        if (gameModule instanceof PieceSlot) {
            PieceSlot pieceSlot = (PieceSlot)((Object)gameModule);
            GamePiece gamePiece = PieceCloner.getInstance().clonePiece(pieceSlot.getPiece());
            properties.setProperty(gamePiece.getType(), ComponentPathBuilder.getInstance().getId(list.toArray(new Configurable[list.size()])));
        } else if (gameModule instanceof Configurable) {
            Configurable configurable = gameModule;
            Configurable[] configurableArray = configurable.getConfigureComponents();
            for (int i = 0; i < configurableArray.length; ++i) {
                list.add(configurableArray[i]);
                this.findPieceSlots(list, properties);
                list.remove(configurableArray[i]);
            }
        }
    }

    private static class ReplaceTrait
    extends Replace {
        private GamePiece replacement;

        public ReplaceTrait(GamePiece gamePiece, GamePiece gamePiece2) {
            super("replace;Replace;R;dummy;;0;0;true", gamePiece);
            this.setProperty("Outer", gamePiece);
            gamePiece.setProperty("Outer", null);
            this.replacement = gamePiece2;
        }

        protected GamePiece createMarker() {
            GamePiece gamePiece = PieceCloner.getInstance().clonePiece(this.replacement);
            if (this.matchRotation) {
                this.matchTraits(this.getInner(), gamePiece);
            }
            return gamePiece;
        }

        public Command replacePiece() {
            return super.replacePiece();
        }
    }
}

