/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.StringArrayConfigurer;
import java.awt.Color;
import java.util.NoSuchElementException;
import javax.swing.KeyStroke;

public class SequenceEncoder {
    private StringBuffer buffer;
    private char delimit;

    public SequenceEncoder(char c) {
        this(null, c);
    }

    public SequenceEncoder(String string, char c) {
        this.delimit = c;
        if (string != null) {
            this.append(string);
        }
    }

    public SequenceEncoder append(String string) {
        if (this.buffer == null) {
            this.buffer = new StringBuffer();
            this.appendEscapedString(string);
        } else {
            this.buffer.append(this.delimit);
            this.appendEscapedString(string);
        }
        return this;
    }

    public SequenceEncoder append(char c) {
        return this.append(String.valueOf(c));
    }

    public SequenceEncoder append(int n) {
        return this.append(String.valueOf(n));
    }

    public SequenceEncoder append(double d) {
        return this.append(String.valueOf(d));
    }

    public SequenceEncoder append(boolean bl) {
        return this.append(String.valueOf(bl));
    }

    public SequenceEncoder append(KeyStroke keyStroke) {
        String string = HotKeyConfigurer.encode(keyStroke);
        return this.append(string != null ? string : "");
    }

    public SequenceEncoder append(Color color) {
        String string = ColorConfigurer.colorToString(color);
        return this.append(string != null ? string : "");
    }

    public SequenceEncoder append(String[] stringArray) {
        return this.append(StringArrayConfigurer.arrayToString(stringArray));
    }

    public String getValue() {
        return this.buffer != null ? this.buffer.toString() : null;
    }

    private void appendEscapedString(String string) {
        int n = 0;
        int n2 = string.indexOf(this.delimit);
        int n3 = this.buffer.length();
        while (n <= n2) {
            this.buffer.append(string.substring(n, n2)).append('\\');
            n = n2;
            n2 = string.indexOf(this.delimit, n2 + 1);
        }
        this.buffer.append(string.substring(n));
        if (string.endsWith("\\") || string.startsWith("'") && string.endsWith("'")) {
            this.buffer.insert(n3, "'").append("'");
        }
    }

    public static void main(String[] stringArray) {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(',');
        for (int i = 0; i < stringArray.length; ++i) {
            sequenceEncoder.append(stringArray[i]);
        }
        System.out.println(sequenceEncoder.getValue());
        Decoder decoder = new Decoder(sequenceEncoder.getValue(), ',');
        while (decoder.hasMoreTokens()) {
            System.out.println(decoder.nextToken());
        }
    }

    public static class Decoder {
        private String val;
        private char delimit;

        public Decoder(String string, char c) {
            this.val = string;
            this.delimit = c;
        }

        public boolean hasMoreTokens() {
            return this.val != null;
        }

        public String nextToken() {
            if (!this.hasMoreTokens()) {
                throw new NoSuchElementException();
            }
            String string = this.val;
            int n = this.val.indexOf(this.delimit);
            if (n < 0) {
                string = this.val;
                this.val = null;
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = 0;
                int n3 = n;
                while (n2 < n3 && this.val.charAt(n3 - 1) == '\\') {
                    stringBuffer.append(this.val.substring(n2, n3 - 1));
                    n2 = n3;
                    n3 = this.val.indexOf(this.delimit, n3 + 1);
                }
                if (n3 < 0) {
                    stringBuffer.append(this.val.substring(n2));
                    this.val = null;
                } else {
                    stringBuffer.append(this.val.substring(n2, n3));
                    this.val = n3 >= this.val.length() - 1 ? "" : this.val.substring(n3 + 1);
                }
                string = stringBuffer.toString();
            }
            if (string.startsWith("'") && string.endsWith("'")) {
                string = string.substring(1, string.length() - 1);
            }
            return string;
        }

        public Decoder copy() {
            return new Decoder(this.val, this.delimit);
        }

        public int nextInt(int n) {
            if (this.val != null) {
                try {
                    n = Integer.parseInt(this.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return n;
        }

        public double nextDouble(double d) {
            if (this.val != null) {
                try {
                    d = Double.parseDouble(this.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return d;
        }

        public boolean nextBoolean(boolean bl) {
            if (this.val != null) {
                bl = "true".equals(this.nextToken());
            }
            return bl;
        }

        public char nextChar(char c) {
            if (this.val != null) {
                String string = this.nextToken();
                c = string.length() > 0 ? string.charAt(0) : c;
            }
            return c;
        }

        public KeyStroke nextKeyStroke(char c) {
            return this.nextKeyStroke(KeyStroke.getKeyStroke((int)c, 2));
        }

        public Color nextColor(Color color) {
            if (this.val != null) {
                String string = this.nextToken();
                color = string.length() > 0 ? ColorConfigurer.stringToColor(string) : null;
            }
            return color;
        }

        public KeyStroke nextKeyStroke(KeyStroke keyStroke) {
            if (this.val != null) {
                String string = this.nextToken();
                keyStroke = string.length() == 0 ? null : (string.indexOf(44) < 0 ? KeyStroke.getKeyStroke((int)string.charAt(0), 2) : HotKeyConfigurer.decode(string));
            }
            return keyStroke;
        }

        public String nextToken(String string) {
            if (this.val != null) {
                string = this.nextToken();
            }
            return string;
        }

        public String[] nextStringArray(int n) {
            String[] stringArray = new String[]{};
            if (this.val != null) {
                stringArray = StringArrayConfigurer.stringToArray(this.nextToken());
            }
            if (stringArray.length < n) {
                String[] stringArray2 = stringArray;
                stringArray = new String[n];
                System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
            }
            return stringArray;
        }
    }
}

