/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.Buildable;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.ValidationReport;
import VASSAL.configure.ValidityChecker;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UniqueIdManager
implements ValidityChecker {
    private List instances = new ArrayList();
    private String prefix;

    public UniqueIdManager(String string) {
        this.prefix = string;
    }

    public void add(Identifyable identifyable) {
        identifyable.setId(this.prefix + this.instances.size());
        this.instances.add(identifyable);
    }

    public void remove(Identifyable identifyable) {
        int n = this.instances.indexOf(identifyable);
        if (n >= 0) {
            int n2 = this.instances.size();
            for (int i = n + 1; i < n2; ++i) {
                ((Identifyable)this.instances.get(i)).setId(this.prefix + (i - 1));
            }
            this.instances.remove(n);
        }
    }

    public static String getIdentifier(Identifyable identifyable) {
        String string = identifyable.getConfigureName();
        if (string == null || string.length() == 0) {
            string = identifyable.getId();
        }
        return string;
    }

    public Iterator getAllInstances() {
        return this.instances.iterator();
    }

    public Identifyable findInstance(String string) {
        if (string != null) {
            Iterator iterator = this.instances.iterator();
            while (iterator.hasNext()) {
                Identifyable identifyable = (Identifyable)iterator.next();
                if (!string.equals(identifyable.getConfigureName()) && !string.equals(identifyable.getId())) continue;
                return identifyable;
            }
        }
        return null;
    }

    public void validate(Buildable buildable, ValidationReport validationReport) {
        if (buildable instanceof Identifyable) {
            Identifyable identifyable = (Identifyable)((Object)buildable);
            if (identifyable.getConfigureName() == null || identifyable.getConfigureName().length() == 0) {
                validationReport.addWarning("A " + ConfigureTree.getConfigureName(buildable.getClass()) + " has not been given a name");
            } else if (this.instances.contains(identifyable)) {
                Identifyable identifyable2 = null;
                Iterator iterator = this.instances.iterator();
                while (iterator.hasNext() && identifyable2 != identifyable) {
                    identifyable2 = (Identifyable)iterator.next();
                    if (identifyable2 == identifyable || !identifyable.getConfigureName().equals(identifyable2.getConfigureName())) continue;
                    validationReport.addWarning("More than one " + ConfigureTree.getConfigureName(buildable.getClass()) + " named " + identifyable.getConfigureName());
                    break;
                }
            }
        }
    }

    public static interface Identifyable {
        public void setId(String var1);

        public String getId();

        public String getConfigureName();
    }
}

