/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Properties;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ZipUpdater
implements Runnable {
    public static final String CHECKSUM_RESOURCE = "checksums";
    public static final String TARGET_ARCHIVE = "target";
    public static final String UPDATED_ARCHIVE_NAME = "finalName";
    public static final String ENTRIES_DIR = "entries/";
    private File oldFile;
    private ZipFile oldZipFile;
    private Properties checkSums;
    private String fileName;
    private Exception error;
    static /* synthetic */ Class class$VASSAL$tools$ZipUpdater;

    public ZipUpdater(File file) throws IOException {
        this.oldFile = file;
        if (!this.oldFile.exists()) {
            throw new IOException("Could not find file " + file.getPath());
        }
    }

    private long getCrc(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        long l = -1L;
        if (zipEntry != null && (l = zipEntry.getCrc()) < 0L) {
            int n;
            CRC32 cRC32 = new CRC32();
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) > 0) {
                cRC32.update(byArray, 0, n);
            }
            l = cRC32.getValue();
        }
        return l;
    }

    private long copyEntry(ZipOutputStream zipOutputStream, ZipEntry zipEntry) throws IOException {
        return this.writeEntry(this.oldZipFile.getInputStream(new ZipEntry(zipEntry.getName())), zipOutputStream, zipEntry);
    }

    private long replaceEntry(ZipOutputStream zipOutputStream, ZipEntry zipEntry) throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream("/entries/" + zipEntry.getName());
        if (inputStream == null) {
            throw new IOException("This updater was created with an original that differs from the file you're trying to update.\nLocal entry does not match original:  " + zipEntry.getName());
        }
        return this.writeEntry(inputStream, zipOutputStream, zipEntry);
    }

    private long writeEntry(InputStream inputStream, ZipOutputStream zipOutputStream, ZipEntry zipEntry) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray, 0, 1024)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray2);
        if (zipEntry.getMethod() == 0) {
            zipEntry.setSize(byArray2.length);
            zipEntry.setCrc(cRC32.getValue());
        }
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.write(byArray2, 0, byArray2.length);
        return cRC32.getValue();
    }

    public void write(File file) throws IOException {
        this.checkSums = new Properties();
        this.checkSums.load((class$VASSAL$tools$ZipUpdater == null ? (class$VASSAL$tools$ZipUpdater = ZipUpdater.class$("VASSAL.tools.ZipUpdater")) : class$VASSAL$tools$ZipUpdater).getResourceAsStream("/checksums"));
        this.oldZipFile = new ZipFile(this.oldFile.getPath());
        File file2 = File.createTempFile("VSL", ".zip");
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
        Object object = ((Hashtable)this.checkSums).keys();
        while (object.hasMoreElements()) {
            long l;
            String string = (String)object.nextElement();
            try {
                l = Long.parseLong(this.checkSums.getProperty(string, "<none>"));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Invalid checksum " + this.checkSums.getProperty(string, "<none>") + " for entry " + string);
            }
            ZipEntry zipEntry = this.oldZipFile.getEntry(string);
            ZipEntry zipEntry2 = new ZipEntry(string);
            zipEntry2.setMethod(zipEntry != null ? zipEntry.getMethod() : 8);
            if (!(l == this.getCrc(this.oldZipFile, zipEntry) ? l != this.copyEntry(zipOutputStream, zipEntry2) : l != this.replaceEntry(zipOutputStream, zipEntry2))) continue;
            throw new IOException("Checksum mismatch for entry " + zipEntry.getName());
        }
        this.oldZipFile.close();
        zipOutputStream.close();
        if (file.getName().equals(this.oldFile.getName())) {
            String string;
            object = file.getName();
            int n = ((String)object).lastIndexOf(".");
            String string2 = string = n < 0 || n == ((String)object).length() - 1 ? (String)object + "Backup" : ((String)object).substring(0, n) + "Backup" + ((String)object).substring(n);
            if (!this.oldFile.renameTo(new File(string))) {
                throw new IOException("Unable to create backup file " + string + ".\nUpdated file is in " + file2.getPath());
            }
        }
        if (!file2.renameTo(file)) {
            throw new IOException("Unable to write to file " + file.getPath() + ".\nUpdated file is in " + file2.getPath());
        }
    }

    public void createUpdater(File file) throws IOException {
        String string = this.oldFile.getName();
        int n = string.indexOf(".");
        String string2 = n >= 0 ? "update" + string.substring(0, n) + ".jar" : "update" + string;
        this.createUpdater(file, new File(string2));
    }

    public void createUpdater(File file, File file2) throws IOException {
        Object object;
        Object object2;
        String string;
        if (!file2.getName().endsWith(".jar")) {
            string = file2.getName().replace('.', '_') + ".jar";
            file2 = new File(file2.getParentFile(), string);
        }
        this.checkSums = new Properties();
        this.oldZipFile = new ZipFile(this.oldFile);
        string = this.oldFile.getName();
        ZipFile zipFile = new ZipFile(file);
        JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(file2));
        Object object3 = zipFile.entries();
        while (object3.hasMoreElements()) {
            long l;
            object2 = object3.nextElement();
            long l2 = this.getCrc(zipFile, (ZipEntry)object2);
            if (l2 != (l = this.getCrc(this.oldZipFile, this.oldZipFile.getEntry(((ZipEntry)object2).getName())))) {
                object = new ZipEntry(ENTRIES_DIR + ((ZipEntry)object2).getName());
                ((ZipEntry)object).setMethod(((ZipEntry)object2).getMethod());
                this.writeEntry(zipFile.getInputStream((ZipEntry)object2), jarOutputStream, (ZipEntry)object);
            }
            ((Hashtable)this.checkSums).put(((ZipEntry)object2).getName(), l2 + "");
        }
        object3 = new ZipEntry("META-INF/MANIFEST.MF");
        ((ZipEntry)object3).setMethod(8);
        object2 = new StringBuffer();
        ((StringBuffer)object2).append("Manifest-Version: 1.0\n").append("Main-Class: VASSAL.tools.ZipUpdater\n");
        this.writeEntry(new ByteArrayInputStream(((StringBuffer)object2).toString().getBytes("UTF-8")), jarOutputStream, (ZipEntry)object3);
        ZipEntry zipEntry = new ZipEntry(TARGET_ARCHIVE);
        zipEntry.setMethod(8);
        this.writeEntry(new ByteArrayInputStream(string.getBytes("UTF-8")), jarOutputStream, zipEntry);
        ZipEntry zipEntry2 = new ZipEntry(UPDATED_ARCHIVE_NAME);
        zipEntry2.setMethod(8);
        this.writeEntry(new ByteArrayInputStream(file.getName().getBytes("UTF-8")), jarOutputStream, zipEntry2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.checkSums.store(byteArrayOutputStream, null);
        ZipEntry zipEntry3 = new ZipEntry(CHECKSUM_RESOURCE);
        zipEntry3.setMethod(8);
        this.writeEntry(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), jarOutputStream, zipEntry3);
        object = this.getClass().getName().replace('.', '/') + ".class";
        ZipEntry zipEntry4 = new ZipEntry((String)object);
        zipEntry4.setMethod(8);
        this.writeEntry(this.getClass().getResourceAsStream("/" + (String)object), jarOutputStream, zipEntry4);
        jarOutputStream.close();
    }

    private ZipUpdater(String string, Exception exception) {
        this.fileName = string;
        this.error = exception;
    }

    public void run() {
        JOptionPane.showMessageDialog(null, "Unable to update " + this.fileName + ".\n" + this.error.getMessage(), "Update failed", 0);
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        String string = "<unknown>";
        try {
            if (stringArray.length > 1) {
                string = stringArray[0];
                String string2 = stringArray[1];
                ZipUpdater zipUpdater = new ZipUpdater(new File(string));
                zipUpdater.createUpdater(new File(string2));
            } else {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((class$VASSAL$tools$ZipUpdater == null ? (class$VASSAL$tools$ZipUpdater = ZipUpdater.class$("VASSAL.tools.ZipUpdater")) : class$VASSAL$tools$ZipUpdater).getResourceAsStream("/target")));
                string = bufferedReader.readLine();
                bufferedReader = new BufferedReader(new InputStreamReader((class$VASSAL$tools$ZipUpdater == null ? (class$VASSAL$tools$ZipUpdater = ZipUpdater.class$("VASSAL.tools.ZipUpdater")) : class$VASSAL$tools$ZipUpdater).getResourceAsStream("/finalName")));
                String string3 = bufferedReader.readLine();
                ZipUpdater zipUpdater = new ZipUpdater(new File(string));
                zipUpdater.write(new File(string3));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            try {
                SwingUtilities.invokeAndWait(new ZipUpdater(string, iOException));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

