/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.p2pchat;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import org.litesoft.p2pchat.ActivePeer;
import org.litesoft.p2pchat.ActivePeerManager;
import org.litesoft.p2pchat.IllegalArgument;
import org.litesoft.p2pchat.MyInfo;
import org.litesoft.p2pchat.PeerInfo;
import org.litesoft.p2pchat.PendingPeerManager;
import org.litesoft.p2pchat.UserDialog;
import org.litesoft.p2pchat.UserDialogPrivMsgAWT;

public class UserDialogAWT
extends Frame
implements UserDialog {
    private MyInfo zMyInfo;
    private ActivePeerManager zActivePeerManager = null;
    private TextField zChatText;
    private TextField zNameText;
    private TextArea zMessagesTextArea;
    private List zPeersList;
    private Hashtable zPrivateMessagersMap = new Hashtable();

    public UserDialogAWT(String string, MyInfo myInfo) {
        super(string);
        IllegalArgument.ifNull("Title", string);
        this.zMyInfo = myInfo;
        IllegalArgument.ifNull("MyInfo", this.zMyInfo);
        this.setLayout(new BorderLayout());
        this.add("North", this.layoutNamePanel());
        this.add("Center", this.layoutReceivedMessagesPanel());
        this.add("East", this.layoutWhoPanel());
        this.add("South", this.layoutChatEntryPanel());
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.show();
        this.showWho();
        this.zChatText.requestFocus();
    }

    public void setActivePeerManager(ActivePeerManager activePeerManager) {
        if (activePeerManager != null) {
            this.zActivePeerManager = activePeerManager;
        }
    }

    public void setPendingPeerManager(PendingPeerManager pendingPeerManager) {
        if (pendingPeerManager != null) {
            // empty if block
        }
    }

    private Panel layoutChatEntryPanel() {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add("West", new Label("Message to Send:"));
        this.zChatText = new TextField();
        panel.add("Center", this.zChatText);
        this.zChatText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UserDialogAWT.this.handleCHAT(actionEvent.getActionCommand());
                UserDialogAWT.this.zChatText.setText("");
            }
        });
        return panel;
    }

    private Panel layoutReceivedMessagesPanel() {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add("North", new Label("Received Messages:"));
        this.zMessagesTextArea = new TextArea();
        panel.add("Center", this.zMessagesTextArea);
        this.zMessagesTextArea.setEnabled(true);
        this.zMessagesTextArea.setEditable(false);
        return panel;
    }

    private Panel layoutWhoPanel() {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add("North", new Label("Who's On:"));
        this.zPeersList = new List(25, false);
        panel.add("Center", this.zPeersList);
        this.zPeersList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                int n = string.indexOf(32);
                if (n != -1) {
                    UserDialogAWT.this.handlePrivateMessageWindowRequest(string.substring(0, n));
                }
                UserDialogAWT.this.zChatText.requestFocus();
            }
        });
        return panel;
    }

    private Panel layoutNamePanel() {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0));
        panel.add(new Label("Name:", 2));
        this.zNameText = new TextField("", 15);
        panel.add(this.zNameText);
        this.zNameText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UserDialogAWT.this.handleNAMEchange(actionEvent.getActionCommand().trim());
                UserDialogAWT.this.zNameText.setText("");
                UserDialogAWT.this.showWho();
                UserDialogAWT.this.zChatText.requestFocus();
            }
        });
        return panel;
    }

    private void send(String string) {
        String string2 = this.zMessagesTextArea.getText();
        string2 = string2 + string + "\n";
        this.zMessagesTextArea.setText(string2);
    }

    private void showWho() {
        this.zPeersList.removeAll();
        this.zPeersList.add(this.zMyInfo.toString(), 0);
        PeerInfo[] peerInfoArray = this.getPeerInfos();
        for (int i = 0; i < peerInfoArray.length; ++i) {
            this.zPeersList.add(peerInfoArray[i].toString(), i + 1);
        }
    }

    public void showUnrecognized(PeerInfo peerInfo, String string) {
        IllegalArgument.ifNull("PeerInfo", peerInfo);
        IllegalArgument.ifNull("BadMessage", string);
        this.send("Unrecognized Command from (" + peerInfo.getID() + " " + peerInfo.getChatName() + "): " + string);
    }

    public void showStreamsFailed(PeerInfo peerInfo) {
        IllegalArgument.ifNull("PeerInfo", peerInfo);
        this.send("Unable to Set up I/O Streams with: " + peerInfo.toString());
    }

    public void showConnectFailed(PeerInfo peerInfo) {
        IllegalArgument.ifNull("PeerInfo", peerInfo);
        this.send("Unable to Connect to: " + peerInfo.toString());
    }

    public void showConnect(PeerInfo peerInfo) {
        IllegalArgument.ifNull("PeerInfo", peerInfo);
        this.showWho();
    }

    public void showDisconnect(PeerInfo peerInfo) {
        IllegalArgument.ifNull("PeerInfo", peerInfo);
        UserDialogPrivMsgAWT userDialogPrivMsgAWT = this.getPrivateMessageWindow(peerInfo);
        if (userDialogPrivMsgAWT != null) {
            this.unregisterPrivateMessager(peerInfo);
            userDialogPrivMsgAWT.dispose();
        }
        this.showWho();
    }

    public void showCHAT(PeerInfo peerInfo, String string) {
        IllegalArgument.ifNull("PeerInfo", peerInfo);
        IllegalArgument.ifNull("Message", string);
        this.send(peerInfo.getID() + " " + peerInfo.getChatName() + ": " + string);
    }

    public void showPMSG(PeerInfo peerInfo, String string) {
        IllegalArgument.ifNull("PeerInfo", peerInfo);
        IllegalArgument.ifNull("Message", string);
        UserDialogPrivMsgAWT userDialogPrivMsgAWT = this.getPrivateMessageWindow(peerInfo);
        if (userDialogPrivMsgAWT != null) {
            userDialogPrivMsgAWT.send(peerInfo.getChatName() + ": " + string);
        } else {
            this.send("Private Message From (" + peerInfo.getID() + " " + peerInfo.getChatName() + "): " + string);
        }
    }

    public void showNAME(PeerInfo peerInfo) {
        IllegalArgument.ifNull("PeerInfo", peerInfo);
        this.showWho();
    }

    public void showHELO(PeerInfo peerInfo) {
        IllegalArgument.ifNull("PeerInfo", peerInfo);
        this.showWho();
    }

    private UserDialogPrivMsgAWT getPrivateMessageWindow(PeerInfo peerInfo) {
        return (UserDialogPrivMsgAWT)this.zPrivateMessagersMap.get(peerInfo);
    }

    public void unregisterPrivateMessager(PeerInfo peerInfo) {
        IllegalArgument.ifNull("PeerInfo", peerInfo);
        this.zPrivateMessagersMap.remove(peerInfo);
    }

    private void openPrivateMessageWindow(ActivePeer activePeer) {
        this.zPrivateMessagersMap.put(activePeer.getPeerInfo(), new UserDialogPrivMsgAWT(this, this.zMyInfo, activePeer));
    }

    private void handleCHAT(String string) {
        if (this.zActivePeerManager == null) {
            this.send("No Peer Manager!");
        } else {
            this.zActivePeerManager.sendToAllCHAT(string);
            this.send(this.zMyInfo.getChatName() + ": " + string);
        }
    }

    private void handleNAMEchange(String string) {
        if (this.zActivePeerManager == null) {
            this.send("No Peer Manager!");
        } else {
            this.zMyInfo.setChatName(string);
            this.zActivePeerManager.sendToAllNAME();
        }
    }

    private PeerInfo[] getPeerInfos() {
        return this.zActivePeerManager != null ? this.zActivePeerManager.getPeerInfos() : new PeerInfo[]{};
    }

    private void handlePrivateMessageWindowRequest(String string) {
        if (this.zActivePeerManager == null) {
            this.send("No Peer Manager!");
        } else {
            ActivePeer activePeer = this.zActivePeerManager.getPeerListenerByID(string);
            if (activePeer == null) {
                this.send("Unrecognized Peer ID: " + string);
            } else {
                this.openPrivateMessageWindow(activePeer);
            }
        }
    }
}

