/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.p2pchat;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.litesoft.p2pchat.ActivePeer;
import org.litesoft.p2pchat.IllegalArgument;
import org.litesoft.p2pchat.MyInfo;
import org.litesoft.p2pchat.UserDialogAWT;

public class UserDialogPrivateMessageAWT
extends Frame {
    private UserDialogAWT zUserDialog;
    private MyInfo zMyInfo;
    private ActivePeer zPeerListener;
    private TextField zChatText;
    private TextArea zMessagesTextArea;

    public UserDialogPrivateMessageAWT(UserDialogAWT userDialogAWT, MyInfo myInfo, ActivePeer activePeer) {
        super("P2P Chat Private Messaging with " + activePeer.getPeerInfo().toString());
        this.zUserDialog = userDialogAWT;
        IllegalArgument.ifNull("UserDialog", this.zUserDialog);
        this.zMyInfo = myInfo;
        IllegalArgument.ifNull("MyInfo", this.zMyInfo);
        this.zPeerListener = activePeer;
        IllegalArgument.ifNull("PeerListener", this.zPeerListener);
        this.setLayout(new BorderLayout());
        this.add("Center", this.layoutReceivedMessagesPanel());
        this.add("South", this.layoutChatEntryPanel());
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                UserDialogPrivateMessageAWT.this.zUserDialog.unregisterPrivateMessager(UserDialogPrivateMessageAWT.this.zPeerListener.getPeerInfo());
                UserDialogPrivateMessageAWT.this.dispose();
            }
        });
        this.show();
    }

    private Panel layoutChatEntryPanel() {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add("West", new Label("Message to Send:"));
        this.zChatText = new TextField();
        panel.add("Center", this.zChatText);
        this.zChatText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                UserDialogPrivateMessageAWT.this.zChatText.setText("");
                UserDialogPrivateMessageAWT.this.zPeerListener.sendPMSG(string);
                UserDialogPrivateMessageAWT.this.send(UserDialogPrivateMessageAWT.this.zMyInfo.getChatName() + ": " + string);
            }
        });
        return panel;
    }

    private Panel layoutReceivedMessagesPanel() {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add("North", new Label("Received Messages:"));
        this.zMessagesTextArea = new TextArea();
        panel.add("Center", this.zMessagesTextArea);
        this.zMessagesTextArea.setEnabled(true);
        this.zMessagesTextArea.setEditable(false);
        return panel;
    }

    public void send(String string) {
        IllegalArgument.ifNull("Message", string);
        String string2 = this.zMessagesTextArea.getText();
        string2 = string2 + string + "\n";
        this.zMessagesTextArea.setText(string2);
    }
}

