/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import org.apache.batik.ext.awt.RenderingHintsKeyExt;
import org.apache.batik.ext.awt.g2d.AbstractGraphics2D;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.image.FopImage;
import org.apache.fop.render.ps.PSGenerator;
import org.apache.fop.render.ps.PSImageUtils;

public class PSGraphics2D
extends AbstractGraphics2D {
    protected Log log = LogFactory.getLog(class$org$apache$fop$render$ps$PSTextPainter == null ? (class$org$apache$fop$render$ps$PSTextPainter = PSGraphics2D.class$("org.apache.fop.render.ps.PSTextPainter")) : class$org$apache$fop$render$ps$PSTextPainter);
    protected PSGenerator gen;
    private boolean clippingDisabled = true;
    protected Font font;
    protected Font overrideFont = null;
    protected String currentFontName;
    protected int currentFontSize;
    protected Color currentColour = new Color(0, 0, 0);
    protected FontInfo fontInfo;
    private Graphics2D fmg;
    static /* synthetic */ Class class$org$apache$fop$render$ps$PSTextPainter;

    public PSGraphics2D(boolean textAsShapes) {
        super(textAsShapes);
        BufferedImage bi = new BufferedImage(1, 1, 2);
        this.fmg = bi.createGraphics();
    }

    public PSGraphics2D(boolean textAsShapes, PSGenerator gen) {
        this(textAsShapes);
        this.setPSGenerator(gen);
    }

    public PSGraphics2D(PSGraphics2D g) {
        super(g);
        BufferedImage bi = new BufferedImage(1, 1, 2);
        this.fmg = bi.createGraphics();
    }

    public void setPSGenerator(PSGenerator gen) {
        this.gen = gen;
    }

    public void setGraphicContext(GraphicContext c) {
        this.gc = c;
        this.setPrivateHints();
    }

    private void setPrivateHints() {
        this.setRenderingHint(RenderingHintsKeyExt.KEY_AVOID_TILE_PAINTING, RenderingHintsKeyExt.VALUE_AVOID_TILE_PAINTING_ON);
    }

    public Graphics create() {
        return new PSGraphics2D(this);
    }

    public FontInfo getFontInfo() {
        return this.fontInfo;
    }

    protected void handleIOException(IOException ioe) {
        ioe.printStackTrace();
    }

    protected void preparePainting() {
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        this.preparePainting();
        this.log.debug("drawImage: " + x + ", " + y + " " + img.getClass().getName());
        int width = img.getWidth(observer);
        int height = img.getHeight(observer);
        if (width == -1 || height == -1) {
            return false;
        }
        Dimension size = new Dimension(width, height);
        BufferedImage buf = this.buildBufferedImage(size);
        Graphics2D g = buf.createGraphics();
        g.setComposite(AlphaComposite.SrcOver);
        g.setBackground(new Color(1, 1, 1, 0));
        g.setPaint(new Color(1, 1, 1, 0));
        g.fillRect(0, 0, width, height);
        g.clip(new Rectangle(0, 0, buf.getWidth(), buf.getHeight()));
        if (!g.drawImage(img, 0, 0, observer)) {
            return false;
        }
        g.dispose();
        byte[] result = new byte[buf.getWidth() * buf.getHeight() * 3];
        Raster raster = buf.getData();
        DataBuffer bd = raster.getDataBuffer();
        int count = 0;
        switch (bd.getDataType()) {
            case 3: {
                int[][] idata = ((DataBufferInt)bd).getBankData();
                for (int i = 0; i < idata.length; ++i) {
                    for (int j = 0; j < idata[i].length; ++j) {
                        if ((idata[i][j] >> 24 & 0xFF) != 255) {
                            result[count++] = -1;
                            result[count++] = -1;
                            result[count++] = -1;
                            continue;
                        }
                        result[count++] = (byte)(idata[i][j] >> 16 & 0xFF);
                        result[count++] = (byte)(idata[i][j] >> 8 & 0xFF);
                        result[count++] = (byte)(idata[i][j] & 0xFF);
                    }
                }
                break;
            }
        }
        try {
            TempImage fopimg = new TempImage(width, height, result, null);
            AffineTransform at = this.getTransform();
            this.gen.saveGraphicsState();
            Shape imclip = this.getClip();
            this.writeClip(imclip);
            this.gen.concatMatrix(at);
            PSImageUtils.renderFopImage(fopimg, 1000 * x, 1000 * y, 1000 * width, 1000 * height, this.gen);
            this.gen.restoreGraphicsState();
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
        return true;
    }

    public BufferedImage buildBufferedImage(Dimension size) {
        return new BufferedImage(size.width, size.height, 2);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        this.preparePainting();
        this.log.warn("NYI: drawImage");
        return true;
    }

    public void dispose() {
        this.gen = null;
        this.font = null;
        this.currentColour = null;
        this.fontInfo = null;
    }

    public void processPathIterator(PathIterator iter) throws IOException {
        double[] vals = new double[6];
        while (!iter.isDone()) {
            int type = iter.currentSegment(vals);
            switch (type) {
                case 3: {
                    this.gen.writeln(this.gen.formatDouble(1000.0 * vals[0]) + " " + this.gen.formatDouble(1000.0 * vals[1]) + " " + this.gen.formatDouble(1000.0 * vals[2]) + " " + this.gen.formatDouble(1000.0 * vals[3]) + " " + this.gen.formatDouble(1000.0 * vals[4]) + " " + this.gen.formatDouble(1000.0 * vals[5]) + " curveto");
                    break;
                }
                case 1: {
                    this.gen.writeln(this.gen.formatDouble(1000.0 * vals[0]) + " " + this.gen.formatDouble(1000.0 * vals[1]) + " lineto");
                    break;
                }
                case 0: {
                    this.gen.writeln(this.gen.formatDouble(1000.0 * vals[0]) + " " + this.gen.formatDouble(1000.0 * vals[1]) + " M");
                    break;
                }
                case 2: {
                    this.gen.writeln(this.gen.formatDouble(1000.0 * vals[0]) + " " + this.gen.formatDouble(1000.0 * vals[1]) + " " + this.gen.formatDouble(1000.0 * vals[2]) + " " + this.gen.formatDouble(1000.0 * vals[3]) + " QUADTO ");
                    break;
                }
                case 4: {
                    this.gen.writeln("closepath");
                    break;
                }
            }
            iter.next();
        }
    }

    public void draw(Shape s) {
        this.preparePainting();
        try {
            this.gen.saveGraphicsState();
            Shape imclip = this.getClip();
            this.writeClip(imclip);
            this.establishColor(this.getColor());
            this.applyPaint(this.getPaint(), false);
            this.applyStroke(this.getStroke());
            this.gen.writeln("newpath");
            PathIterator iter = s.getPathIterator(this.getTransform());
            this.processPathIterator(iter);
            this.doDrawing(false, true, false);
            this.gen.restoreGraphicsState();
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
    }

    protected void writeClip(Shape s) {
        if (s == null) {
            return;
        }
        if (!this.clippingDisabled) {
            this.preparePainting();
            try {
                this.gen.writeln("newpath");
                PathIterator iter = s.getPathIterator(this.getTransform());
                this.processPathIterator(iter);
                this.gen.writeln("clippath");
            }
            catch (IOException ioe) {
                this.handleIOException(ioe);
            }
        }
    }

    protected void applyPaint(Paint paint, boolean fill) {
        this.preparePainting();
        if (paint instanceof GradientPaint) {
            this.log.warn("NYI: Gradient paint");
        } else if (paint instanceof TexturePaint) {
            this.log.warn("NYI: texture paint");
        }
    }

    protected void applyStroke(Stroke stroke) {
        this.preparePainting();
        try {
            if (stroke instanceof BasicStroke) {
                BasicStroke bs = (BasicStroke)stroke;
                float[] da = bs.getDashArray();
                if (da != null) {
                    this.gen.write("[");
                    for (int count = 0; count < da.length; ++count) {
                        this.gen.write("" + 1000 * (int)da[count]);
                        if (count >= da.length - 1) continue;
                        this.gen.write(" ");
                    }
                    this.gen.write("] ");
                    float offset = bs.getDashPhase();
                    this.gen.writeln(1000 * (int)offset + " setdash");
                }
                int ec = bs.getEndCap();
                switch (ec) {
                    case 0: {
                        this.gen.writeln("0 setlinecap");
                        break;
                    }
                    case 1: {
                        this.gen.writeln("1 setlinecap");
                        break;
                    }
                    case 2: {
                        this.gen.writeln("2 setlinecap");
                        break;
                    }
                    default: {
                        this.log.warn("Unsupported line cap: " + ec);
                    }
                }
                int lj = bs.getLineJoin();
                switch (lj) {
                    case 0: {
                        this.gen.writeln("0 setlinejoin");
                        break;
                    }
                    case 1: {
                        this.gen.writeln("1 setlinejoin");
                        break;
                    }
                    case 2: {
                        this.gen.writeln("2 setlinejoin");
                        break;
                    }
                    default: {
                        this.log.warn("Unsupported line join: " + lj);
                    }
                }
                float lw = bs.getLineWidth();
                this.gen.writeln(this.gen.formatDouble(1000.0f * lw) + " setlinewidth");
                float ml = bs.getMiterLimit();
                this.gen.writeln(this.gen.formatDouble(1000.0f * ml) + " setmiterlimit");
            }
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        this.preparePainting();
        this.log.warn("NYI: drawRenderedImage");
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.preparePainting();
        this.log.warn("NYI: drawRenderableImage");
    }

    protected void establishColor(Color c) throws IOException {
        StringBuffer p = new StringBuffer();
        float[] comps = c.getColorComponents(null);
        if (c.getColorSpace().getType() == 5) {
            boolean same;
            boolean bl = same = comps[0] == comps[1] && comps[0] == comps[2];
            if (same) {
                p.append(this.gen.formatDouble(comps[0]));
            } else {
                for (int i = 0; i < c.getColorSpace().getNumComponents(); ++i) {
                    if (i > 0) {
                        p.append(" ");
                    }
                    p.append(this.gen.formatDouble(comps[i]));
                }
            }
            if (same) {
                p.append(" setgray");
            } else {
                p.append(" setrgbcolor");
            }
        } else if (c.getColorSpace().getType() == 9) {
            for (int i = 0; i < c.getColorSpace().getNumComponents(); ++i) {
                if (i > 0) {
                    p.append(" ");
                }
                p.append(this.gen.formatDouble(comps[i]));
            }
            p.append(" setcmykcolor");
        } else {
            p.append(this.gen.formatDouble(comps[0]));
            p.append(" setgray");
        }
        this.gen.writeln(p.toString());
    }

    public void drawString(String s, float x, float y) {
        if (this.textAsShapes) {
            this.drawStringAsShapes(s, x, y);
        } else {
            this.drawStringAsText(s, x, y);
        }
    }

    public void drawStringAsShapes(String s, float x, float y) {
        java.awt.Font awtFont = super.getFont();
        FontRenderContext frc = super.getFontRenderContext();
        GlyphVector gv = awtFont.createGlyphVector(frc, s);
        Shape glyphOutline = gv.getOutline(x, y);
        this.fill(glyphOutline);
    }

    public void drawStringAsText(String s, float x, float y) {
        this.preparePainting();
        this.log.trace("drawString('" + s + "', " + x + ", " + y + ")");
        try {
            if (this.overrideFont == null) {
                java.awt.Font awtFont = this.getFont();
                this.font = this.createFont(awtFont);
            } else {
                this.font = this.overrideFont;
                this.overrideFont = null;
            }
            this.establishColor(this.getColor());
            this.establishCurrentFont();
            Shape imclip = this.getClip();
            this.writeClip(imclip);
            this.gen.saveGraphicsState();
            AffineTransform trans = this.getTransform();
            this.gen.writeln("[" + this.toArray(trans) + "] concat");
            this.gen.writeln(this.gen.formatDouble(1000.0f * x) + " " + this.gen.formatDouble(1000.0f * y) + " moveto ");
            this.gen.writeln("1 -1 scale");
            StringBuffer sb = new StringBuffer("(");
            this.escapeText(s, sb);
            sb.append(") t ");
            this.gen.writeln(sb.toString());
            this.gen.restoreGraphicsState();
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
    }

    protected String toArray(AffineTransform at) {
        double[] vals = new double[6];
        at.getMatrix(vals);
        return this.gen.formatDouble5(vals[0]) + " " + this.gen.formatDouble5(vals[1]) + " " + this.gen.formatDouble5(vals[2]) + " " + this.gen.formatDouble5(vals[3]) + " " + this.gen.formatDouble(1000.0 * vals[4]) + " " + this.gen.formatDouble(1000.0 * vals[5]);
    }

    private void escapeText(String text, StringBuffer target) {
        int l = text.length();
        for (int i = 0; i < l; ++i) {
            char ch = text.charAt(i);
            char mch = this.font.mapChar(ch);
            PSGenerator.escapeChar(mch, target);
        }
    }

    private Font createFont(java.awt.Font f) {
        int weight;
        String fontFamily = f.getFamily();
        if (fontFamily.equals("sanserif")) {
            fontFamily = "sans-serif";
        }
        int fontSize = 1000 * f.getSize();
        String style = f.isItalic() ? "italic" : "normal";
        String fontKey = this.fontInfo.findAdjustWeight(fontFamily, style, weight = f.isBold() ? 700 : 400);
        if (fontKey == null) {
            fontKey = this.fontInfo.findAdjustWeight("sans-serif", style, weight);
        }
        return new Font(fontKey, this.fontInfo.getMetricsFor(fontKey), fontSize);
    }

    private void establishCurrentFont() throws IOException {
        if (this.currentFontName != this.font.getFontName() || this.currentFontSize != this.font.getFontSize()) {
            this.gen.writeln(this.font.getFontName() + " " + this.font.getFontSize() + " F");
            this.currentFontName = this.font.getFontName();
            this.currentFontSize = this.font.getFontSize();
        }
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.preparePainting();
        this.log.warn("NYI: drawString(AttributedCharacterIterator)");
    }

    public void fill(Shape s) {
        this.preparePainting();
        try {
            this.gen.saveGraphicsState();
            Shape imclip = this.getClip();
            this.writeClip(imclip);
            this.establishColor(this.getColor());
            this.applyPaint(this.getPaint(), true);
            this.gen.writeln("newpath");
            PathIterator iter = s.getPathIterator(this.getTransform());
            this.processPathIterator(iter);
            this.doDrawing(true, false, iter.getWindingRule() == 0);
            this.gen.restoreGraphicsState();
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
    }

    protected void doDrawing(boolean fill, boolean stroke, boolean nonzero) throws IOException {
        this.preparePainting();
        if (fill) {
            if (stroke) {
                if (!nonzero) {
                    this.gen.writeln("stroke");
                } else {
                    this.gen.writeln("stroke");
                }
            } else if (!nonzero) {
                this.gen.writeln("fill");
            } else {
                this.gen.writeln("fill");
            }
        } else {
            this.gen.writeln("stroke");
        }
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public void setOverrideFont(Font font) {
        this.overrideFont = font;
    }

    public FontMetrics getFontMetrics(java.awt.Font f) {
        return this.fmg.getFontMetrics(f);
    }

    public void setXORMode(Color c1) {
        this.log.warn("NYI: setXORMode");
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.log.warn("NYI: copyArea");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class TempImage
    implements FopImage {
        private int height;
        private int width;
        private int bitsPerPixel;
        private ColorSpace colorSpace;
        private int bitmapSiye;
        private byte[] bitmaps;
        private byte[] mask;
        private Color transparentColor;

        TempImage(int width, int height, byte[] bitmaps, byte[] mask) {
            this.height = height;
            this.width = width;
            this.bitsPerPixel = 8;
            this.colorSpace = ColorSpace.getInstance(1000);
            this.bitmaps = bitmaps;
            this.mask = mask;
        }

        public String getMimeType() {
            return "application/octet-stream";
        }

        public boolean load(int type) {
            switch (type) {
                case 1: {
                    break;
                }
                case 4: {
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown load type: " + type);
                }
            }
            return true;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public ColorSpace getColorSpace() {
            return this.colorSpace;
        }

        public ICC_Profile getICCProfile() {
            return null;
        }

        public int getBitsPerPixel() {
            return this.bitsPerPixel;
        }

        public boolean isTransparent() {
            return this.getTransparentColor() != null;
        }

        public Color getTransparentColor() {
            return this.transparentColor;
        }

        public boolean hasSoftMask() {
            return this.mask != null;
        }

        public byte[] getSoftMask() {
            return this.mask;
        }

        public byte[] getBitmaps() {
            return this.bitmaps;
        }

        public int getBitmapsSize() {
            return this.getWidth() * this.getHeight() * 3;
        }

        public byte[] getRessourceBytes() {
            return null;
        }

        public int getRessourceBytesSize() {
            return 0;
        }

        public int getIntrinsicWidth() {
            return (int)((double)(this.getWidth() * 72000) / this.getHorizontalResolution());
        }

        public int getIntrinsicHeight() {
            return (int)((double)(this.getHeight() * 72000) / this.getVerticalResolution());
        }

        public double getHorizontalResolution() {
            return 72.0;
        }

        public double getVerticalResolution() {
            return 72.0;
        }
    }
}

